// FileMapping.h
// 2008/11/27

#pragma once

namespace QAX {

// FileMappingImpl
class FileMappingImpl : public QFileMapping {

	HANDLE m_hFile;
	HANDLE m_hMapping;

	FileMappingImpl(HANDLE f, HANDLE m) :
		m_hFile(f),
		m_hMapping(m)
	{
	}

public:

	static QFileMapping* Create(
		LPCWSTR path)
	{
		HANDLE hFile = CreateFileW(
			path,
			GENERIC_READ,
			FILE_SHARE_READ,
			0,
			OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL,
			0);
		if (hFile == INVALID_HANDLE_VALUE) {
			WinError::Throw("CreateFileW");
		}

		HANDLE hMapping = CreateFileMappingW(
			hFile,
			0,
			PAGE_READONLY,
			0,
			0,
			0);
		if (hMapping == 0) {
			DWORD e = GetLastError();
			CloseHandle(hMapping);
			WinError::Throw("CreateFileMappingW", e);
		}

		FileMappingImpl* impl = new FileMappingImpl(
			hFile,
			hMapping);

		return impl;
	}

	~FileMappingImpl()
	{
	}

	/* */

	virtual void STDCALL Release()
	{
		try {
			if (m_hMapping != 0) {
				if (!CloseHandle(m_hMapping)) {
					WinError::Throw("CloseHandle");
				}
				m_hMapping = 0;
			}

			if (m_hFile != INVALID_HANDLE_VALUE) {
				if (!CloseHandle(m_hFile)) {
					WinError::Throw("CloseHandle");
				}
				m_hFile = INVALID_HANDLE_VALUE;
			}

		} catch (...) {
			delete this;
			throw;
		}

		delete this;
	}

	virtual const VOID* STDCALL MapView(
		UINT64 offset,
		SIZE_T size)
	{
		SIZE_T cb = ((size + g_PAGE_SIZE - 1) / g_PAGE_SIZE) * g_PAGE_SIZE;

		ULARGE_INTEGER o;
		o.QuadPart = offset;

		VOID* pv = MapViewOfFile(
			m_hMapping,
			FILE_MAP_READ,
			o.HighPart,
			o.LowPart,
			cb);
		if (pv == 0) {
			WinError::Throw("MapViewOfFile");
		}

		return pv;
	}

	virtual void STDCALL UnmapView(
		const VOID* p)
	{
		if (!UnmapViewOfFile(p)) {
			WinError::Throw("UnmapViewOfFile");
		}
	}

	/* */

}; // FileMappingImpl

} // namespace QAX

