/* Utils.h    */
/* 2009/07/22 */

#pragma once

#include "MemoryAllocator.h"

#include "StreamReader.h"

/* */

QO_Allocator_t* Allocator_Get();

/* */

void QO_StreamReader_Init(
	QO_StreamReader_t* t,
	FILE*              fp);

void QO_StreamReader_IStream(
	QO_StreamReader_t* t,
	IStream*           p);

/* */

/* QO_MemoryPool */
struct QO_MemoryPool {

	VOID*  Block;
	SIZE_T TotalSize;

}; /* QO_MemoryPool */

typedef struct QO_MemoryPool QO_MemoryPool_t;

/* */

void QO_MemoryPool_Init(
	QO_MemoryPool_t* t);

void QO_MemoryPool_Release(
	QO_MemoryPool_t* t,
	QO_Allocator_t*  alloc);

VOID* QO_MemoryPool_Allocate(
	QO_MemoryPool_t* t,
	QO_Allocator_t*  alloc,
	SIZE_T           cb);

/* */

