// QMediaType.h
// 2009/08/21

#pragma once

/* */

// QMediaType
struct QMediaType : public AM_MEDIA_TYPE {

	QMediaType()
	{
		memset(this, 0, sizeof(QMediaType));
	}

	~QMediaType()
	{
		SafeRelease();
	}

	void SafeRelease()
	{
		if (pUnk != 0) {
			pUnk->Release();
			pUnk = 0;
		}

		if (pbFormat != 0) {
			CoTaskMemFree(pbFormat);
			pbFormat = 0;
		}

		memset(this, 0, sizeof(QMediaType));
	}

	void Assign(const AM_MEDIA_TYPE* p)
	{
		SafeRelease();

		if (p != 0) {
			Copy(this, p);
		}
	}

	static bool Copy(AM_MEDIA_TYPE* d, const AM_MEDIA_TYPE* p)
	{
		memcpy(d, p, sizeof(AM_MEDIA_TYPE));

		if (p->pbFormat != 0) {
			BYTE* pb = static_cast<BYTE*>(CoTaskMemAlloc(p->cbFormat));
			if (pb == 0) {
				return false;
			}

			memcpy(pb, p->pbFormat, p->cbFormat);

			d->pbFormat = pb;
		}

		if (p->pUnk != 0) {
			p->pUnk->Release();
		}

		return true;
	}

	static AM_MEDIA_TYPE* CopyFrom(const AM_MEDIA_TYPE* p)
	{
		if (p == 0) {
			return 0;
		}

		AM_MEDIA_TYPE* d = static_cast<AM_MEDIA_TYPE*>(CoTaskMemAlloc(
			sizeof(AM_MEDIA_TYPE)));
		if (d == 0) {
			return 0;
		}

		if (!Copy(d, p)) {
			CoTaskMemFree(d);
			return 0;
		}

		return d;
	}

	static void Free(AM_MEDIA_TYPE* p)
	{
		if (p == 0) {
			return;
		}

		if (p->pUnk != 0) {
			p->pUnk->Release();
		}

		if (p->pbFormat != 0) {
			CoTaskMemFree(p->pbFormat);
		}

		CoTaskMemFree(p);
	}

	/* */

	void SetFormat(const void* pv, SIZE_T cb)
	{
		if (pbFormat != 0) {
			CoTaskMemFree(pbFormat);

			pbFormat = 0;
			cbFormat = 0;
		}

		BYTE* pb = static_cast<BYTE*>(CoTaskMemAlloc(cb));
		if (pb == 0) {
			return;
		}

		memcpy(pb, pv, cb);

		cbFormat = cb;
		pbFormat = pb;
	}

	void SetAudio(
		INT32 channels,
		INT32 samplingRate)
	{
		majortype = MEDIATYPE_Audio;
		subtype   = MEDIASUBTYPE_PCM;

		bFixedSizeSamples    = TRUE;
		bTemporalCompression = FALSE;

		formattype = FORMAT_WaveFormatEx;

		lSampleSize = channels * 2 * samplingRate;

		WAVEFORMATEX wfx = { 0 };

		wfx.wFormatTag      = WAVE_FORMAT_PCM;
		wfx.nChannels       = channels;
		wfx.nSamplesPerSec  = samplingRate;
		wfx.nAvgBytesPerSec = channels * 2 * samplingRate;
		wfx.nBlockAlign     = channels * 2;
		wfx.wBitsPerSample  = 16;
		wfx.cbSize          = 0;

		SetFormat(&wfx, sizeof(wfx));
	}

	/* */

}; // QMediaType

/* */

// QEnumMediaTypes
class ATL_NO_VTABLE QEnumMediaTypes :
	public ATL::CComObjectRootEx<ATL::CComMultiThreadModel>,

	public IEnumMediaTypes {

	ATL::CComCriticalSection m_cs;

	AM_MEDIA_TYPE* m_pStart;
	AM_MEDIA_TYPE* m_pEnd;

	AM_MEDIA_TYPE* m_p;

	ATL::CComPtr<IUnknown> m_Pin;

public:

	DECLARE_NOT_AGGREGATABLE(QEnumMediaTypes)

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	BEGIN_COM_MAP(QEnumMediaTypes)
		COM_INTERFACE_ENTRY(IEnumMediaTypes)
	END_COM_MAP()

public:

	QEnumMediaTypes() : m_pStart(0), m_pEnd(0), m_p(0)
	{
	}

	~QEnumMediaTypes()
	{
	}

	HRESULT FinalConstruct()
	{
		ATLTRACE("QEnumMediaTypes::FinalConstruct()\n");

		HRESULT hRslt = m_cs.Init();
		if (FAILED(hRslt)) {
			return hRslt;
		}

		return S_OK;
	}

	void FinalRelease()
	{
		ATLTRACE("QEnumMediaTypes::FinalRelease()\n");

		m_Pin.Release();
	}

	void Init(AM_MEDIA_TYPE* s, AM_MEDIA_TYPE* e, IUnknown* p)
	{
		m_pStart = s;
		m_pEnd   = e;

		m_p = m_pStart;

		m_Pin = p;
	}

	/* */

	static HRESULT Create(AM_MEDIA_TYPE* s, AM_MEDIA_TYPE* e, IUnknown* p, IEnumMediaTypes** ppEnum)
	{
		if (ppEnum == 0) {
			return E_INVALIDARG;
		}

		ATL::CComObject<QEnumMediaTypes>* obj = 0;

		HRESULT hRslt = ATL::CComObject<QEnumMediaTypes>::CreateInstance(&obj);
		if (FAILED(hRslt)) {
			return hRslt;
		}

		obj->Init(s, e, p);

		hRslt = obj->QueryInterface(ppEnum);
		if (FAILED(hRslt)) {
			delete obj;
			return hRslt;
		}

		return S_OK;
	}

	/* */

	STDMETHOD(Next)(
		ULONG           cMediaTypes,
		AM_MEDIA_TYPE** ppMediaTypes,
		ULONG*          pcFetched)
	{
		ATL::CComCritSecLock<ATL::CComCriticalSection> lock(m_cs);

		if (ppMediaTypes == 0) {
			return E_INVALIDARG;
		}

		if (pcFetched == 0 && cMediaTypes != 1) {
			return E_INVALIDARG;
		}

		if (pcFetched != 0) {
			*pcFetched = 0;
		}

		ULONG i;
		AM_MEDIA_TYPE** pp = ppMediaTypes;
		for (i = 0; i < cMediaTypes && m_p < m_pEnd; i++, pp++, m_p++) {
			AM_MEDIA_TYPE* mt = QMediaType::CopyFrom(m_p);
			if (mt == 0) {
				return E_OUTOFMEMORY;
			}
			*pp = mt;
		}

		if (pcFetched != 0) {
			*pcFetched = i;
		}

		if (i == 0) {
			return S_FALSE;
		}

		return S_OK;
	}

	STDMETHOD(Skip)(
		ULONG cMediaTypes)
	{
		ATL::CComCritSecLock<ATL::CComCriticalSection> lock(m_cs);

		m_p += cMediaTypes;

		if (m_p > m_pEnd) {
			m_p = m_pEnd;
		}

		return S_OK;
	}


	STDMETHOD(Reset)(void)
	{
		ATL::CComCritSecLock<ATL::CComCriticalSection> lock(m_cs);

		m_p = m_pStart;

		return S_OK;
	}

	STDMETHOD(Clone)( 
		IEnumMediaTypes** ppEnum)
	{
		ATL::CComCritSecLock<ATL::CComCriticalSection> lock(m_cs);

		HRESULT hRslt = Create(m_pStart, m_pEnd, m_Pin, ppEnum);
		if (FAILED(hRslt)) {
			return hRslt;
		}

		return S_OK;
	}

	/* */

}; // QEnumMediaTypes

/* */

