// SetupPool.cs
// 2008/11/19

using System;
using System.IO;
using System.Collections.Generic;
using System.Security.Cryptography;

namespace QAX {

// Setup
public struct Setup {

	public String Key;

	public Byte[] Hash;

	public Int32 IdSize;
	public Int32 SetupSize;

	public Byte[] Payload;

} // Setup

// SetupPool
public class SetupPool {

	private List<Setup> _list;

	public SetupPool()
	{
		_list = new List<Setup>();
	}

	public Int32 Add(Byte[] id, Byte[] setup)
	{
		Byte[] payload = new Byte[id.Length + setup.Length];

		Buffer.BlockCopy(id,    0, payload, 0,         id.Length   );
		Buffer.BlockCopy(setup, 0, payload, id.Length, setup.Length);

		var sha1 = new SHA1Managed();
		Byte[] hash = sha1.ComputeHash(payload);

		String key = Utils.ToString(hash);

		for (Int32 i = 0; i < _list.Count; i++) {
			if (_list[i].Key == key) {
				return i;
			}
		}

		Int32 idx = _list.Count;

		var s = new Setup();

		s.Key       = key;
		s.Hash      = hash;
		s.IdSize    = id.Length;
		s.SetupSize = setup.Length;
		s.Payload   = payload;

		_list.Add(s);

		return idx;
	}

	public Int32 Add(Byte[] payload)
	{
		Int32 idx = _list.Count;

		var s = new Setup();

		s.Payload = payload;

		_list.Add(s);

		return idx;
	}

	public Chunk ToChunk()
	{
		var chunk = new Chunk();

		var ms = new MemoryStream();

		Int32 index = 0;

		using (var w = new BinaryWriter(ms)) {
			Setup[] stps = _list.ToArray();
			Int32[] lens = new Int32[stps.Length];

			Byte[] buffer = new Byte[16];

			for (Int32 i = 0; i < stps.Length; i++) {
				Int32 len = 0;

				if (stps[i].Hash != null) {
					w.Write(stps[i].Hash);
					len += stps[i].Hash.Length;

					Int32 id_len = Utils.ToBinary((UInt64)stps[i].IdSize,    buffer, 0,      buffer.Length         );
					Int32 st_len = Utils.ToBinary((UInt64)stps[i].SetupSize, buffer, id_len, buffer.Length - id_len);
					w.Write(buffer, 0, id_len + st_len);
					len += id_len + st_len;
				}

				w.Write(stps[i].Payload);
				len += stps[i].Payload.Length;

				lens[i] = len;

				index += len;
			}

			Utils.WriteLengths(w, lens);
		}

		chunk.Payload = ms.ToArray();
		chunk.Index   = index;

		return chunk;
	}

	/* */

	public static Byte[] MakeSetup(Byte[] id, Byte[] setup)
	{
		Byte[] payload = new Byte[id.Length + setup.Length];

		Buffer.BlockCopy(id,    0, payload, 0,         id.Length   );
		Buffer.BlockCopy(setup, 0, payload, id.Length, setup.Length);

		var sha1 = new SHA1Managed();
		Byte[] hash = sha1.ComputeHash(payload);

		var ms = new MemoryStream();
		using (var w = new BinaryWriter(ms)) {
			w.Write(hash);

			Byte[] buffer = new Byte[16];
			Int32 id_len = Utils.ToBinary((UInt64)id.Length,    buffer, 0,      buffer.Length         );
			Int32 st_len = Utils.ToBinary((UInt64)setup.Length, buffer, id_len, buffer.Length - id_len);
			w.Write(buffer, 0, id_len + st_len);

			w.Write(payload);
		}

		return ms.ToArray();
	}

	/* */

} // SetupPool

} // namespace QAX

