/*
 * Copyright (C) 2010 root42 Inc. All rights reserved.
 */

/**
 * R42フレームワーク
 *
 * 引数チェック用ユーティリティ
 *
 * @author root42 Inc.
 * @version $Id: ArgContract.js 2777 2010-05-05 10:55:32Z kaz $
 */

var ArgContract = {};


/**
 * 引数がnullでないことをチェックします。
 *
 * @param name 引数名
 * @param value 引数値
 */
ArgContract.notNull = /* void */ function(/* String */ name, /* Object */ value) {
    if (value == null) {
        throw new Error(name + " is null");
    }
};


/**
 * 引数が指定のタイプであることをチェックします。
 *
 * @param name 引数名
 * @param type 引数型
 * @param value 引数値
 */
ArgContract.isTypeof = /* void */ function(/* String */ name, /* String */ type, /* Object */ value) {
    ArgContract.notNull(name, value);

    if ((typeof value) != type) {
        throw new Error(name + " is not " + type + ": " + (typeof value));
    }
};


/**
 * 引数が空白文字列でないことをチェックします。
 *
 * @param name 引数名
 * @param value 引数値
 */
ArgContract.notBlank = /* void */ function(/* String */ name, /* String */ value) {
    ArgContract.isTypeof(name, "string", value);

    if (value.match(/^[\s　]*$/g) != null) {
        throw new Error(name + " is blank");
    }
};
