/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.util.Collection;
import java.util.EnumSet;
import rescuecore2.log.Logger;
import rescuecore2.messages.Command;
import rescuecore2.registry.EntityFactory;
import rescuecore2.registry.Registry;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.StandardEntityFactory;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import sample.AbstractSampleAgent;

public class CustomRegistryTestAgent
extends AbstractSampleAgent<Human> {
    public String toString() {
        return "Custom registry test agent";
    }

    public Registry getPreferredRegistry(Registry parent) {
        Registry result = new Registry("Custom registry", parent);
        result.registerEntityFactory((EntityFactory)new CustomEntityFactory());
        return result;
    }

    @Override
    protected void postConnect() {
        super.postConnect();
        Logger.info((String)("Custom registry test agent " + this.getID() + " connected"));
        Logger.info((String)("Current registry: " + Registry.getCurrentRegistry()));
    }

    protected void think(int time, ChangeSet changed, Collection<Command> heard) {
        this.sendRest(time);
    }

    protected EnumSet<StandardEntityURN> getRequestedEntityURNsEnum() {
        return EnumSet.of(StandardEntityURN.FIRE_BRIGADE, StandardEntityURN.POLICE_FORCE, StandardEntityURN.AMBULANCE_TEAM);
    }

    private static class CustomEntityFactory
    implements EntityFactory {
        private StandardEntityFactory downstream = StandardEntityFactory.INSTANCE;

        private CustomEntityFactory() {
        }

        public Entity makeEntity(String urn, EntityID id) {
            return this.downstream.makeEntity(urn, id);
        }

        public String[] getKnownEntityURNs() {
            return this.downstream.getKnownEntityURNs();
        }

        public String toString() {
            return "Custom entity factory";
        }
    }
}

