/*
 * Decompiled with CFR 0.152.
 */
package rescuecore;

import java.io.Serializable;
import rescuecore.Handy;
import rescuecore.InputBuffer;
import rescuecore.OutputBuffer;

public abstract class Property
implements Serializable {
    private int type;
    protected int lastUpdate;
    protected Object lastUpdateSource;

    protected Property(int type) {
        this.type = type;
        this.lastUpdate = -2;
        this.lastUpdateSource = null;
    }

    public int getType() {
        return this.type;
    }

    public abstract boolean read(InputBuffer var1, int var2, Object var3);

    public abstract void write(OutputBuffer var1);

    public int getLastUpdate() {
        return this.lastUpdate;
    }

    public Object getLastUpdateSource() {
        return this.lastUpdateSource;
    }

    public boolean isOlderThan(int time) {
        return this.lastUpdate < time;
    }

    public boolean isValueKnown() {
        return this.lastUpdate >= 0;
    }

    public boolean isValueAssumed() {
        return this.lastUpdate == -1;
    }

    public String toString() {
        return Handy.getPropertyName(this.type) + ": " + this.getStringValue() + " (last update: " + this.lastUpdate + ")";
    }

    public abstract String getStringValue();

    public abstract boolean merge(Property var1);
}

