/*
 * Decompiled with CFR 0.152.
 */
package rescuecore;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.List;
import rescuecore.Connection;

public class TCPConnection
implements Connection {
    private Socket socket;
    private List q;
    private ReadThread read;
    private IOException toThrow;
    private InetAddress destination;
    private int port;
    private OutputStream out;

    public TCPConnection(InetAddress destination, int port) throws SocketException, IOException {
        this.socket = new Socket(destination, port);
        this.socket.setSoTimeout(1000);
        this.q = new LinkedList();
        this.toThrow = null;
        this.read = new ReadThread();
        this.read.start();
        this.destination = destination;
        this.port = port;
        this.out = this.socket.getOutputStream();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public void close() {
        this.read.kill();
        try {
            this.out.close();
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void send(byte[] bytes) throws IOException {
        this.out.write((byte)(bytes.length >> 24 & 0xFF));
        this.out.write((byte)(bytes.length >> 16 & 0xFF));
        this.out.write((byte)(bytes.length >> 8 & 0xFF));
        this.out.write((byte)(bytes.length & 0xFF));
        this.out.write(bytes);
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] receive(int timeout) throws IOException, InterruptedException {
        List list = this.q;
        synchronized (list) {
            if (this.toThrow != null) {
                throw this.toThrow;
            }
            if (this.q.size() == 0) {
                if (timeout < 1) {
                    this.q.wait();
                } else {
                    this.q.wait(timeout);
                }
            }
            if (this.toThrow != null) {
                throw this.toThrow;
            }
            if (this.q.size() == 0) {
                return null;
            }
            return (byte[])this.q.remove(0);
        }
    }

    private class ReadThread
    extends Thread {
        private boolean running = true;
        private boolean alive = true;
        private final Object aliveLock = new Object();
        private InputStream in;

        ReadThread() throws IOException {
            this.in = TCPConnection.this.socket.getInputStream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void kill() {
            this.running = false;
            Object object = this.aliveLock;
            synchronized (object) {
                while (this.alive) {
                    try {
                        this.aliveLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                try {
                    int amount;
                    int length = this.in.read() << 24 | this.in.read() << 16 | this.in.read() << 8 | this.in.read();
                    if (length < 0) {
                        this.running = false;
                        continue;
                    }
                    byte[] data = new byte[length];
                    for (int count = 0; count < length; count += amount) {
                        amount = this.in.read(data, count, length - count);
                    }
                    List list = TCPConnection.this.q;
                    synchronized (list) {
                        TCPConnection.this.q.add(data);
                        TCPConnection.this.q.notifyAll();
                    }
                }
                catch (InterruptedIOException e) {
                }
                catch (SocketException e) {
                    this.running = false;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    List list = TCPConnection.this.q;
                    synchronized (list) {
                        TCPConnection.this.toThrow = e;
                    }
                }
            }
            try {
                this.in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Object object = this.aliveLock;
            synchronized (object) {
                this.alive = false;
                this.aliveLock.notifyAll();
            }
        }
    }
}

