/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.commands;

import rescuecore.InputBuffer;
import rescuecore.OutputBuffer;
import rescuecore.commands.AgentCommand;

public class AKChannel
extends AgentCommand {
    private byte[] channels;

    public AKChannel(int senderID, int time, byte channel) {
        this(senderID, time, new byte[]{channel});
    }

    public AKChannel(int senderID, int time, byte[] channels) {
        super(144, senderID, time);
        this.channels = new byte[channels.length];
        System.arraycopy(channels, 0, this.channels, 0, channels.length);
    }

    public AKChannel(InputBuffer in) {
        super(144, 0, 0);
        this.read(in);
    }

    @Override
    public void write(OutputBuffer out) {
        super.write(out);
        out.writeInt(this.channels.length);
        for (int i = 0; i < this.channels.length; ++i) {
            out.writeByte(this.channels[i]);
        }
    }

    @Override
    public void read(InputBuffer in) {
        super.read(in);
        this.channels = new byte[in.readInt()];
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = in.readByte();
        }
    }

    public byte[] getChannels() {
        return this.channels;
    }
}

