/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.log;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import rescuecore.InputBuffer;
import rescuecore.Memory;
import rescuecore.commands.Commands;
import rescuecore.commands.Update;
import rescuecore.log.InvalidLogException;
import rescuecore.log.LogVersion2;

public abstract class Log {
    public static final String HEADER_VERSION_0 = "RoboCup-Rescue Prototype Log 00\u0000";
    public static final String HEADER_VERSION_1 = "RoboCup-Rescue Prototype Log 01\u0000";
    public static final String HEADER_VERSION_2 = "RoboCup-Rescue Prototype Log 02\u0000";
    public static final int HEADER_LENGTH = "RoboCup-Rescue Prototype Log 00\u0000".length();

    public abstract int getMaxTimestep();

    public abstract Memory getMemory(int var1);

    public abstract Update getUpdate(int var1);

    public abstract Commands getCommands(int var1);

    public abstract Map<String, String> getConfigValues();

    public static Log generateLog(String filename) throws IOException, InvalidLogException {
        File file = new File(filename);
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        byte[] data = new byte[(int)file.length()];
        in.readFully(data);
        InputBuffer input = new InputBuffer(data);
        byte[] preamble = new byte[HEADER_LENGTH];
        input.readBytes(preamble);
        String preambleString = new String(preamble);
        if (HEADER_VERSION_0.equals(preambleString)) {
            throw new InvalidLogException("Log version 0 is no longer supported");
        }
        if (HEADER_VERSION_1.equals(preambleString)) {
            throw new InvalidLogException("Log version 1 is no longer supported");
        }
        if (HEADER_VERSION_2.equals(preambleString)) {
            return new LogVersion2(input);
        }
        throw new InvalidLogException("Unknown log version: " + preambleString);
    }
}

