/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools.simulationrunner;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import rescuecore.tools.simulationrunner.XMLDecodingException;
import rescuecore.tools.simulationrunner.XMLTag;

public class XMLDocumentParser {
    public static XMLTag parse(InputStream in) throws XMLDecodingException, IOException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            Handler handler = new Handler();
            parser.parse(new InputSource(in), (DefaultHandler)handler);
            return handler.root;
        }
        catch (ParserConfigurationException e) {
            throw new XMLDecodingException(e);
        }
        catch (SAXException e) {
            throw new XMLDecodingException(e);
        }
    }

    public static XMLTag parse(Reader in) throws XMLDecodingException, IOException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            Handler handler = new Handler();
            parser.parse(new InputSource(in), (DefaultHandler)handler);
            return handler.root;
        }
        catch (ParserConfigurationException e) {
            throw new XMLDecodingException(e);
        }
        catch (SAXException e) {
            throw new XMLDecodingException(e);
        }
    }

    private static class Handler
    extends DefaultHandler {
        XMLTag root;
        XMLTag current;
        Stack stack;

        private Handler() {
        }

        @Override
        public void startDocument() {
            this.root = null;
            this.current = null;
            this.stack = new Stack();
        }

        @Override
        public void startElement(String uri, String localname, String qName, Attributes attributes) {
            if (this.current != null) {
                this.stack.push(this.current);
                XMLTag next = new XMLTag(qName);
                this.current.addChild(next);
                this.current = next;
            } else {
                this.root = this.current = new XMLTag(qName);
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.current.setAttribute(attributes.getQName(i), attributes.getValue(i));
            }
        }

        @Override
        public void endElement(String uri, String localname, String qName) {
            this.current = this.stack.size() == 0 ? null : (XMLTag)this.stack.pop();
        }

        @Override
        public void characters(char[] data, int start, int length) {
            String s = new String(data, start, length);
            if (s.trim().equals("")) {
                return;
            }
            if (this.current != null) {
                this.current.appendText(s);
            }
        }
    }
}

