/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.entities;

import java.awt.Polygon;
import java.awt.Shape;
import rescuecore2.misc.Pair;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardPropertyURN;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.EntityListener;
import rescuecore2.worldmodel.Property;
import rescuecore2.worldmodel.WorldModel;
import rescuecore2.worldmodel.properties.EntityRefProperty;
import rescuecore2.worldmodel.properties.IntArrayProperty;
import rescuecore2.worldmodel.properties.IntProperty;

public class Blockade
extends StandardEntity {
    private IntProperty x;
    private IntProperty y;
    private EntityRefProperty position;
    private IntArrayProperty apexes;
    private IntProperty repairCost;
    private Shape shape;

    public Blockade(EntityID id) {
        super(id);
        this.x = new IntProperty((Enum)StandardPropertyURN.X);
        this.y = new IntProperty((Enum)StandardPropertyURN.Y);
        this.position = new EntityRefProperty((Enum)StandardPropertyURN.POSITION);
        this.apexes = new IntArrayProperty((Enum)StandardPropertyURN.APEXES);
        this.repairCost = new IntProperty((Enum)StandardPropertyURN.REPAIR_COST);
        this.registerProperties(new Property[]{this.x, this.y, this.position, this.apexes, this.repairCost});
        this.shape = null;
        this.addEntityListener(new ApexesListener());
    }

    public Blockade(Blockade other) {
        super(other);
        this.x = new IntProperty(other.x);
        this.y = new IntProperty(other.y);
        this.position = new EntityRefProperty(other.position);
        this.apexes = new IntArrayProperty(other.apexes);
        this.repairCost = new IntProperty(other.repairCost);
        this.registerProperties(new Property[]{this.x, this.y, this.position, this.apexes, this.repairCost});
        this.shape = null;
        this.addEntityListener(new ApexesListener());
    }

    @Override
    public Pair<Integer, Integer> getLocation(WorldModel<? extends StandardEntity> world) {
        if (!this.x.isDefined() || !this.y.isDefined()) {
            return null;
        }
        return new Pair((Object)this.x.getValue(), (Object)this.y.getValue());
    }

    protected Entity copyImpl() {
        return new Blockade(this.getID());
    }

    @Override
    public StandardEntityURN getStandardURN() {
        return StandardEntityURN.BLOCKADE;
    }

    public Property getProperty(String urn) {
        StandardPropertyURN type;
        try {
            type = StandardPropertyURN.fromString(urn);
        }
        catch (IllegalArgumentException e) {
            return super.getProperty(urn);
        }
        switch (type) {
            case X: {
                return this.x;
            }
            case Y: {
                return this.y;
            }
            case POSITION: {
                return this.position;
            }
            case APEXES: {
                return this.apexes;
            }
            case REPAIR_COST: {
                return this.repairCost;
            }
        }
        return super.getProperty(urn);
    }

    public IntProperty getXProperty() {
        return this.x;
    }

    public int getX() {
        return this.x.getValue();
    }

    public void setX(int x) {
        this.x.setValue(x);
    }

    public boolean isXDefined() {
        return this.x.isDefined();
    }

    public void undefineX() {
        this.x.undefine();
    }

    public IntProperty getYProperty() {
        return this.y;
    }

    public int getY() {
        return this.y.getValue();
    }

    public void setY(int y) {
        this.y.setValue(y);
    }

    public boolean isYDefined() {
        return this.y.isDefined();
    }

    public void undefineY() {
        this.y.undefine();
    }

    public IntArrayProperty getApexesProperty() {
        return this.apexes;
    }

    public int[] getApexes() {
        return this.apexes.getValue();
    }

    public void setApexes(int[] apexes) {
        this.apexes.setValue(apexes);
    }

    public boolean isApexesDefined() {
        return this.apexes.isDefined();
    }

    public void undefineApexes() {
        this.apexes.undefine();
    }

    public EntityRefProperty getPositionProperty() {
        return this.position;
    }

    public EntityID getPosition() {
        return this.position.getValue();
    }

    public void setPosition(EntityID position) {
        this.position.setValue(position);
    }

    public boolean isPositionDefined() {
        return this.position.isDefined();
    }

    public void undefinePosition() {
        this.position.undefine();
    }

    public IntProperty getRepairCostProperty() {
        return this.repairCost;
    }

    public int getRepairCost() {
        return this.repairCost.getValue();
    }

    public void setRepairCost(int cost) {
        this.repairCost.setValue(cost);
    }

    public boolean isRepairCostDefined() {
        return this.repairCost.isDefined();
    }

    public void undefineRepairCost() {
        this.repairCost.undefine();
    }

    public Shape getShape() {
        if (this.shape == null) {
            int[] allApexes = this.getApexes();
            int count = allApexes.length / 2;
            int[] xs = new int[count];
            int[] ys = new int[count];
            for (int i = 0; i < count; ++i) {
                xs[i] = allApexes[i * 2];
                ys[i] = allApexes[i * 2 + 1];
            }
            this.shape = new Polygon(xs, ys, count);
        }
        return this.shape;
    }

    private class ApexesListener
    implements EntityListener {
        private ApexesListener() {
        }

        public void propertyChanged(Entity e, Property p, Object oldValue, Object newValue) {
            if (p == Blockade.this.apexes) {
                Blockade.this.shape = null;
            }
        }
    }
}

