/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.entities;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rescuecore2.misc.EncodingTools;
import rescuecore2.standard.entities.Edge;
import rescuecore2.worldmodel.AbstractProperty;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.Property;

public class EdgeListProperty
extends AbstractProperty {
    private List<Edge> edges;

    public EdgeListProperty(String urn) {
        super(urn);
        this.edges = new ArrayList<Edge>();
    }

    public EdgeListProperty(Enum<?> urn) {
        super(urn);
        this.edges = new ArrayList<Edge>();
    }

    public EdgeListProperty(String urn, List<Edge> edges) {
        super(urn, true);
        this.edges = new ArrayList<Edge>(edges);
    }

    public EdgeListProperty(Enum<?> urn, List<Edge> edges) {
        super(urn, true);
        this.edges = new ArrayList<Edge>(edges);
    }

    public EdgeListProperty(EdgeListProperty other) {
        super((AbstractProperty)other);
        this.edges = new ArrayList<Edge>(other.edges);
    }

    public List<Edge> getValue() {
        if (!this.isDefined()) {
            return null;
        }
        return Collections.unmodifiableList(this.edges);
    }

    public void setEdges(List<Edge> newEdges) {
        this.edges.clear();
        this.edges.addAll(newEdges);
        this.setDefined();
    }

    public void addEdge(Edge edge) {
        this.edges.add(edge);
        this.setDefined();
    }

    public void clearEdges() {
        this.edges.clear();
    }

    public void takeValue(Property p) {
        if (p instanceof EdgeListProperty) {
            EdgeListProperty e = (EdgeListProperty)p;
            if (e.isDefined()) {
                this.setEdges((List<Edge>)e.getValue());
            } else {
                this.undefine();
            }
        } else {
            throw new IllegalArgumentException((Object)((Object)this) + " cannot take value from " + p);
        }
    }

    public void write(OutputStream out) throws IOException {
        EncodingTools.writeInt32((int)this.edges.size(), (OutputStream)out);
        for (Edge next : this.edges) {
            EncodingTools.writeInt32((int)next.getStartX(), (OutputStream)out);
            EncodingTools.writeInt32((int)next.getStartY(), (OutputStream)out);
            EncodingTools.writeInt32((int)next.getEndX(), (OutputStream)out);
            EncodingTools.writeInt32((int)next.getEndY(), (OutputStream)out);
            if (next.isPassable()) {
                EncodingTools.writeInt32((int)next.getNeighbour().getValue(), (OutputStream)out);
                continue;
            }
            EncodingTools.writeInt32((int)0, (OutputStream)out);
        }
    }

    public void read(InputStream in) throws IOException {
        int count = EncodingTools.readInt32((InputStream)in);
        this.edges.clear();
        for (int i = 0; i < count; ++i) {
            int startX = EncodingTools.readInt32((InputStream)in);
            int startY = EncodingTools.readInt32((InputStream)in);
            int endX = EncodingTools.readInt32((InputStream)in);
            int endY = EncodingTools.readInt32((InputStream)in);
            EntityID neighbour = null;
            int id = EncodingTools.readInt32((InputStream)in);
            if (id != 0) {
                neighbour = new EntityID(id);
            }
            this.edges.add(new Edge(startX, startY, endX, endY, neighbour));
        }
        this.setDefined();
    }

    public EdgeListProperty copy() {
        return new EdgeListProperty(this);
    }
}

