/*
 * Decompiled with CFR 0.152.
 */
package rescuecore;

import rescuecore.InputBuffer;
import rescuecore.OutputBuffer;
import rescuecore.Property;

public class IntProperty
extends Property {
    private int value;

    public IntProperty(int type) {
        super(type);
    }

    public IntProperty(int type, boolean value) {
        this(type, value ? 1 : 0);
    }

    public IntProperty(int type, int value) {
        super(type);
        this.value = value;
        this.lastUpdate = 0;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public String getStringValue() {
        StringBuffer result = new StringBuffer();
        result.append(this.value);
        return result.toString();
    }

    public boolean setValue(int newValue, int timestamp, Object source) {
        this.lastUpdate = timestamp;
        this.lastUpdateSource = source;
        if (this.value == newValue) {
            return false;
        }
        this.value = newValue;
        return true;
    }

    public boolean updateValue(int newValue, int timestamp, Object source) {
        if (timestamp <= this.lastUpdate) {
            return false;
        }
        if (this.lastUpdate >= 0 && newValue == this.value) {
            return false;
        }
        this.lastUpdate = timestamp;
        this.lastUpdateSource = source;
        this.value = newValue;
        return true;
    }

    @Override
    public boolean merge(Property p) {
        if (p instanceof IntProperty) {
            return this.updateValue(((IntProperty)p).value, p.lastUpdate, p.lastUpdateSource);
        }
        return false;
    }

    @Override
    public void write(OutputBuffer out) {
        out.writeInt(this.value);
    }

    @Override
    public boolean read(InputBuffer in, int timestamp, Object source) {
        int newValue = in.readInt();
        return this.updateValue(newValue, timestamp, source);
    }
}

