/*
 * Decompiled with CFR 0.152.
 */
package rescuecore;

import java.io.IOException;
import rescuecore.Connection;
import rescuecore.RescueMessage;
import rescuecore.commands.Command;

public abstract class RescueComponent {
    private RescueMessage currentMessage;
    private Connection connection;

    public abstract void handleMessage(Command var1);

    public abstract int getComponentType();

    public abstract Command generateConnectCommand();

    public abstract boolean handleConnectOK(Command var1);

    public abstract String handleConnectError(Command var1);

    public abstract boolean isRunning();

    public abstract void shutdown();

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void sendMessage(RescueMessage message) {
        if (this.connection == null) {
            System.out.println(this + " tried to send to a null socket");
            return;
        }
        try {
            this.connection.send(message.toByteArray());
        }
        catch (IOException e) {
            System.err.println("Error while sending message: " + e);
            e.printStackTrace();
        }
    }

    protected void appendCommand(Command c) {
        if (this.currentMessage == null) {
            this.currentMessage = new RescueMessage();
        }
        this.currentMessage.append(c);
    }

    protected void flushCommands() {
        if (this.currentMessage != null) {
            this.sendMessage(this.currentMessage);
        }
        this.currentMessage = null;
    }
}

