/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import rescuecore.ArrayProperty;
import rescuecore.HashMemory;
import rescuecore.IntProperty;
import rescuecore.Memory;
import rescuecore.Property;
import rescuecore.RescueObject;
import rescuecore.debug.DebugEntry;
import rescuecore.debug.DebugLog;
import rescuecore.debug.Handler;
import rescuecore.debug.OutlineRenderer;
import rescuecore.view.Layer;
import rescuecore.view.Map;
import rescuecore.view.ObjectInspector;
import rescuecore.view.ObjectSelector;

public class DebugPane
extends JPanel {
    private DebugLog log;
    private String name;
    private Memory memory;
    protected JTabbedPane tabs;
    private int timeStep;
    private Map map;
    private Layer moveHistory;
    private ArrayList<Handler> handlers;
    private JPanel handlerPanel;
    public static final int HANDLER_WIDTH = 200;
    int height = 0;

    public DebugPane(DebugLog log, String name) {
        super(new BorderLayout());
        this.log = log;
        this.name = name;
        ObjectInspector inspector = new ObjectInspector();
        this.memory = new HashMemory();
        this.setName(name);
        this.map = new Map(this.memory);
        ObjectSelector selector = new ObjectSelector(this.map);
        this.map.addMouseListener(selector);
        selector.addObjectSelectionListener(inspector);
        this.add((Component)this.map, "Center");
        this.map.addLayer(Layer.createBuildingLayer(this.memory));
        this.map.addLayer(Layer.createRoadLayer(this.memory));
        this.map.addLayer(Layer.createNodeLayer(this.memory));
        this.map.addLayer(Layer.createHumanoidLayer(this.memory));
        this.moveHistory = new Layer("Movement History");
        this.moveHistory.addRenderer(RescueObject[].class, OutlineRenderer.YELLOW);
        this.map.addLayer(this.moveHistory);
        this.handlerPanel = new JPanel();
        this.handlerPanel.setLayout(new BoxLayout(this.handlerPanel, 1));
        JScrollPane sp = new JScrollPane(inspector, 22, 32);
        sp.setPreferredSize(new Dimension(200, 200));
        this.handlerPanel.add(sp);
        this.add((Component)new JScrollPane(this.handlerPanel, 22, 32), "East");
        this.handlers = new ArrayList(10);
    }

    public void registerHandler(Handler h) {
        Layer lay;
        h.setMemory(this.memory);
        this.handlers.add(h);
        JComponent comp = h.getComponent();
        if (comp != null) {
            this.handlerPanel.add(comp);
            this.height += (int)comp.getPreferredSize().getHeight();
            this.handlerPanel.setPreferredSize(new Dimension(210, this.height));
        }
        if ((lay = h.getLayer()) != null) {
            this.map.addLayer(lay);
        }
    }

    protected void moveToTimeStep(int timeStep) {
        this.memory = new HashMemory();
        for (int i = 0; i <= timeStep; ++i) {
            Collection<DebugEntry> entries = this.log.getEntriesForTime(this.name, i);
            for (DebugEntry next : entries) {
                this.processEntry(next);
            }
        }
        this.map.setMemory(this.memory);
        for (Handler next : this.handlers) {
            next.setMemory(this.memory);
        }
        this.repaint();
    }

    private void processEntry(DebugEntry entry) {
        block4: {
            block7: {
                Property p;
                block6: {
                    Property p2;
                    block5: {
                        block3: {
                            if (!(entry instanceof DebugEntry.RescueObjectEntry)) break block3;
                            RescueObject object = ((DebugEntry.RescueObjectEntry)entry).getObject();
                            this.memory.add(object.copy(), entry.getTimestep());
                            break block4;
                        }
                        if (!(entry instanceof DebugEntry.RescueObjectCollectionEntry)) break block5;
                        Collection<RescueObject> objects = ((DebugEntry.RescueObjectCollectionEntry)entry).getObjects();
                        for (RescueObject next : objects) {
                            this.memory.add(next.copy(), entry.getTimestep());
                        }
                        break block4;
                    }
                    if (!(entry instanceof DebugEntry.IntPropertyUpdateEntry)) break block6;
                    int property = ((DebugEntry.IntPropertyUpdateEntry)entry).getProperty();
                    int value = ((DebugEntry.IntPropertyUpdateEntry)entry).getNewValue();
                    int id = ((DebugEntry.IntPropertyUpdateEntry)entry).getObjectID();
                    RescueObject o = this.memory.lookup(id);
                    if (o == null || !((p2 = o.getProperty(property)) instanceof IntProperty)) break block4;
                    ((IntProperty)p2).setValue(value, entry.getTimestep(), null);
                    break block4;
                }
                if (!(entry instanceof DebugEntry.ArrayPropertyUpdateEntry)) break block7;
                int property = ((DebugEntry.ArrayPropertyUpdateEntry)entry).getProperty();
                int[] value = ((DebugEntry.ArrayPropertyUpdateEntry)entry).getNewValue();
                int id = ((DebugEntry.ArrayPropertyUpdateEntry)entry).getObjectID();
                RescueObject o = this.memory.lookup(id);
                if (o == null || !((p = o.getProperty(property)) instanceof ArrayProperty)) break block4;
                ((ArrayProperty)p).setValues(value, entry.getTimestep(), null);
                break block4;
            }
            if (entry instanceof DebugEntry.ObjectDebugEntry) {
                Handler h;
                Object obj = ((DebugEntry.ObjectDebugEntry)entry).getObject();
                for (int j = this.handlers.size() - 1; j >= 0 && !(h = this.handlers.get(j)).handle(obj, entry.getTimestep()); --j) {
                }
            }
        }
    }
}

