/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.debug;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import rescuecore.ArrayProperty;
import rescuecore.IntProperty;
import rescuecore.Property;
import rescuecore.RescueComponent;
import rescuecore.RescueObject;
import rescuecore.debug.DebugEntry;

public class DebugWriter {
    private static Map<RescueComponent, DebugTarget> componentTargets = new HashMap<RescueComponent, DebugTarget>();
    private static Map<RescueComponent, String> componentNames = new HashMap<RescueComponent, String>();
    private static Map<String, DebugTarget> targets = new HashMap<String, DebugTarget>();

    public static void register(RescueComponent component, String name, String targetName) {
        DebugTarget target = DebugWriter.createTarget(targetName);
        if (target != null) {
            componentTargets.put(component, target);
            componentNames.put(component, name);
        }
    }

    public static void logInitialObjects(RescueComponent component, Collection<RescueObject> objects) {
        DebugWriter.log(component, new DebugEntry.RescueObjectCollectionEntry(objects, 0));
    }

    public static void logObjectAdded(RescueComponent component, RescueObject o, int time) {
        DebugWriter.log(component, new DebugEntry.RescueObjectEntry(o, time));
    }

    public static void logObjectChanged(RescueComponent component, RescueObject o, Property p, int time) {
        if (p instanceof IntProperty) {
            DebugWriter.log(component, new DebugEntry.IntPropertyUpdateEntry(o.getID(), p.getType(), ((IntProperty)p).getValue(), time));
        }
        if (p instanceof ArrayProperty) {
            DebugWriter.log(component, new DebugEntry.ArrayPropertyUpdateEntry(o.getID(), p.getType(), ((ArrayProperty)p).getValues(), time));
        }
    }

    public static void logUserObject(RescueComponent component, Object o, int time) {
        DebugWriter.log(component, new DebugEntry.ObjectDebugEntry(o, time));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(RescueComponent component, DebugEntry entry) {
        DebugTarget target = componentTargets.get(component);
        String name = componentNames.get(component);
        if (target == null) {
            System.err.println("WARNING: Unregistered component tried to log something: " + component);
        } else {
            DebugTarget debugTarget = target;
            synchronized (debugTarget) {
                try {
                    target.write(name, entry);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush(RescueComponent component) {
        DebugTarget target = componentTargets.get(component);
        if (target != null) {
            DebugTarget debugTarget = target;
            synchronized (debugTarget) {
                try {
                    target.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void flushAll() {
        for (RescueComponent next : componentTargets.keySet()) {
            DebugWriter.flush(next);
        }
    }

    private static DebugTarget createTarget(String target) {
        DebugTarget result = targets.get(target);
        if (result == null) {
            try {
                result = new FileDebugTarget(target);
                targets.put(target, result);
            }
            catch (IOException e) {
                System.err.println("ERROR: Could not create debug target: " + e);
                return null;
            }
        }
        return result;
    }

    private static class FileDebugTarget
    extends DebugTarget {
        private ObjectOutputStream out;

        public FileDebugTarget(String fileName) throws IOException {
            this.out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
        }

        @Override
        public void write(String owner, DebugEntry entry) throws IOException {
            this.out.writeUTF(owner);
            this.out.writeObject(entry);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
            this.out = null;
        }
    }

    private static abstract class DebugTarget {
        private DebugTarget() {
        }

        public abstract void write(String var1, DebugEntry var2) throws IOException;

        public abstract void flush() throws IOException;

        public abstract void close() throws IOException;
    }
}

