/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.sample;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import rescuecore.PlatoonAgent;
import rescuecore.RescueObject;
import rescuecore.commands.AKChannel;
import rescuecore.event.MemoryListener;
import rescuecore.event.ObjectAddedEvent;
import rescuecore.event.ObjectChangedEvent;
import rescuecore.objects.PoliceForce;
import rescuecore.objects.Road;
import rescuecore.sample.SampleSearch;

public class SamplePoliceForce
extends PlatoonAgent {
    private static final byte CHANNEL = 2;
    private List targets = new ArrayList();

    public SamplePoliceForce() {
        super(68);
    }

    private PoliceForce me() {
        return (PoliceForce)this.memory.lookup(this.id);
    }

    @Override
    public void initialise(RescueObject[] knowledge) {
        super.initialise(knowledge);
        this.memory.addMemoryListener(new MemoryListener(){

            @Override
            public void objectAdded(ObjectAddedEvent event) {
                RescueObject o = event.getObject();
                if (o.isRoad() && ((Road)o).isBlocked()) {
                    SamplePoliceForce.this.targets.add(o);
                }
            }

            @Override
            public void objectChanged(ObjectChangedEvent event) {
                RescueObject o = event.getObject();
                if (o.isRoad() && event.getProperty() == 15) {
                    if (((Road)o).isBlocked()) {
                        SamplePoliceForce.this.targets.add(o);
                    } else {
                        SamplePoliceForce.this.targets.remove(o);
                    }
                }
            }
        });
    }

    @Override
    public void sense() {
        RescueObject location;
        if (this.timeStep == 1) {
            this.appendCommand(new AKChannel(this.id, this.timeStep, 2));
        }
        if ((location = this.getLocation()).isRoad() && ((Road)location).isBlocked()) {
            this.clear((Road)location);
            this.tell(("Clearing " + location.getID()).getBytes(), (byte)2);
            return;
        }
        SampleSearch.sortByDistance(this.targets, (RescueObject)this.me(), this.memory);
        Iterator it = this.targets.iterator();
        while (it.hasNext()) {
            Road next = (Road)it.next();
            if (!next.isBlocked()) {
                it.remove();
                continue;
            }
            int[] path = SampleSearch.breadthFirstSearch(this.getLocation(), next, this.memory);
            if (path == null) continue;
            this.move(path);
            return;
        }
        Collection<RescueObject> allRoads = this.memory.getObjectsOfType(2);
        Road[] roads = new Road[allRoads.size()];
        allRoads.toArray(roads);
        Road target = roads[(int)(Math.random() * (double)roads.length)];
        int[] path = SampleSearch.breadthFirstSearch(this.getLocation(), target, this.memory);
        if (path != null) {
            this.move(path);
        }
    }

    @Override
    protected void hear(int from, byte[] msg, byte channel) {
    }
}

