/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nagoyau.is.ss.kishii.suntori.message;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.BaseMessageType;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.IMessage;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.RCRSCSMessageConverter;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.data.DataType;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.data.EntityIDData;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.data.EntityIDListData;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.data.RCRSCSData;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.data.ValueData;
import rescuecore2.misc.Pair;
import rescuecore2.worldmodel.EntityID;

public abstract class RCRSCSMessage
implements IMessage {
    protected BaseMessageType messageType;
    protected static final DataType[] COMMON_DATA_TYPE = new DataType[]{DataType.TIME};
    protected List<RCRSCSData<?>> data;

    public RCRSCSMessage(BaseMessageType type, int time) {
        this.messageType = type;
        int len = COMMON_DATA_TYPE.length + type.getDataType().length;
        this.data = new ArrayList(len);
        int i = 0;
        while (i < len) {
            this.data.add(null);
            ++i;
        }
        this.setData(new ValueData(DataType.TIME, time));
    }

    public RCRSCSMessage(List<RCRSCSData<?>> data, BaseMessageType type) {
        this.messageType = type;
        this.data = data;
    }

    public RCRSCSMessage(BaseMessageType type, List<Integer> bitList, int offset, EnumMap<DataType, Integer> bitSizeMap) {
        this.messageType = type;
        int len = COMMON_DATA_TYPE.length + type.getDataType().length;
        this.data = new ArrayList(len);
        int i = 0;
        while (i < len) {
            this.data.add(null);
            ++i;
        }
        EnumMap<DataType, Integer> counter = new EnumMap<DataType, Integer>(DataType.class);
        DataType[] dataTypeArray = this.getDataTypeArray();
        int n = dataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataType dt = dataTypeArray[n2];
            int i2 = RCRSCSMessageConverter.getDataTypeIndex(counter, dt, 1);
            if (dt != DataType.ID_LIST && dt != DataType.AREA_LIST) {
                Integer bitSize = bitSizeMap.get((Object)dt);
                int value = RCRSCSMessageConverter.bitToInt(bitList, offset, bitSize);
                this.setData(DataType.createData(dt, value), i2);
                offset += bitSize.intValue();
            } else {
                EntityIDListData d = DataType.createIDListData(dt);
                int listSize = RCRSCSMessageConverter.bitToInt(bitList, offset, 32);
                offset += 32;
                int bitSize = 32;
                if (dt == DataType.AREA_LIST) {
                    bitSize = bitSizeMap.get((Object)DataType.AREA);
                }
                int j = 0;
                while (j < listSize) {
                    int value = RCRSCSMessageConverter.bitToInt(bitList, offset, bitSize);
                    d.setData(new EntityID(value));
                    offset += bitSize;
                    ++j;
                }
                this.setData(d, i2);
            }
            ++n2;
        }
    }

    public int getMessageBitSize(EnumMap<DataType, Integer> bitSizeMap) {
        int res = 0;
        for (RCRSCSData<?> d : this.data) {
            EntityIDListData eild;
            if (d == null) continue;
            DataType type = d.getType();
            if (type == DataType.AREA_LIST) {
                res += 32;
                eild = (EntityIDListData)d;
                res += bitSizeMap.get((Object)DataType.AREA) * ((List)eild.getData()).size();
                continue;
            }
            if (type == DataType.ID_LIST) {
                eild = (EntityIDListData)d;
                res += 32 * (((List)eild.getData()).size() + 1);
                continue;
            }
            res += bitSizeMap.get((Object)type).intValue();
        }
        return res;
    }

    @Override
    public List<RCRSCSData<?>> getData() {
        return new ArrayList(this.data);
    }

    @Override
    public void setData(RCRSCSData<?> data) {
        this.setData(data, 0);
    }

    @Override
    public void setData(RCRSCSData<?> data, int index) {
        int targetIndex = 0;
        DataType dType = data.getType();
        int i = 0;
        while (i < COMMON_DATA_TYPE.length) {
            if (COMMON_DATA_TYPE[i] == data.getType()) {
                if (targetIndex == index) {
                    this.data.set(i, data);
                    return;
                }
                ++targetIndex;
            }
            ++i;
        }
        DataType[] necessary = this.messageType.getDataType();
        int i2 = 0;
        while (i2 < necessary.length) {
            if (necessary[i2] == dType) {
                if (targetIndex == index) {
                    this.data.set(COMMON_DATA_TYPE.length + i2, data);
                    return;
                }
                ++targetIndex;
            }
            ++i2;
        }
        System.err.println("illegal argument to set message value:" + (Object)((Object)dType) + "," + index + ",data=" + data + " " + this.getClass());
        new Exception().printStackTrace();
    }

    public boolean isSendable() {
        boolean res = true;
        int i = 0;
        while (i < this.messageType.getDataType().length) {
            if (this.data.get(i) == null) {
                res = false;
                break;
            }
            ++i;
        }
        return res;
    }

    public BaseMessageType getMessageType() {
        return this.messageType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.messageType == null ? 0 : this.messageType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RCRSCSMessage other = (RCRSCSMessage)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        return !(this.messageType == null ? other.messageType != null : !this.messageType.equals((Object)other.messageType));
    }

    protected RCRSCSData<?> getData(DataType dType, int index) {
        int targetIndex = 0;
        int i = 0;
        while (i < COMMON_DATA_TYPE.length) {
            if (COMMON_DATA_TYPE[i] == dType) {
                if (targetIndex == index) {
                    return this.data.get(index);
                }
                ++targetIndex;
            }
            ++i;
        }
        DataType[] necessary = this.messageType.getDataType();
        int i2 = 0;
        while (i2 < necessary.length) {
            if (necessary[i2] == dType) {
                if (targetIndex == index) {
                    return this.data.get(COMMON_DATA_TYPE.length + i2);
                }
                ++targetIndex;
            }
            ++i2;
        }
        System.err.println("illegal argument to get message value:" + (Object)((Object)dType) + "," + index);
        new Exception().printStackTrace();
        return null;
    }

    protected EntityID getID(DataType dType, int index) {
        EntityID res = null;
        RCRSCSData<?> d = this.getData(dType, index);
        if (d != null) {
            if (d instanceof EntityIDData) {
                res = (EntityID)((EntityIDData)d).getData();
            } else {
                Integer id = (Integer)((ValueData)d).getData();
                if (id != null) {
                    res = new EntityID(id.intValue());
                }
            }
        }
        return res;
    }

    protected int getHP(int index) {
        Integer id;
        int res = -1;
        RCRSCSData<?> d = this.getData(DataType.HP, index);
        if (d != null && (id = (Integer)((ValueData)d).getData()) != null) {
            res = id;
        }
        return res;
    }

    protected int getSendTime(int index) {
        Integer id;
        int res = -1;
        RCRSCSData<?> d = this.getData(DataType.TIME, index);
        if (d != null && (id = (Integer)((ValueData)d).getData()) != null) {
            res = id;
        }
        return res;
    }

    public int getSendTime() {
        return this.getSendTime(0);
    }

    protected int getDamage(int index) {
        Integer id;
        int res = -1;
        RCRSCSData<?> d = this.getData(DataType.DAMAGE, index);
        if (d != null && (id = (Integer)((ValueData)d).getData()) != null) {
            res = id;
        }
        return res;
    }

    protected int getBuriedness(int index) {
        Integer id;
        int res = -1;
        RCRSCSData<?> d = this.getData(DataType.BURIEDNESS, index);
        if (d != null && (id = (Integer)((ValueData)d).getData()) != null) {
            res = id;
        }
        return res;
    }

    protected int getFieryness(int index) {
        Integer id;
        int res = -1;
        RCRSCSData<?> d = this.getData(DataType.FIERYNESS, index);
        if (d != null && (id = (Integer)((ValueData)d).getData()) != null) {
            res = id;
        }
        return res;
    }

    protected int getWaterPower(int index) {
        Integer id;
        int res = -1;
        RCRSCSData<?> d = this.getData(DataType.WATER_POWER, index);
        if (d != null && (id = (Integer)((ValueData)d).getData()) != null) {
            res = id;
        }
        return res;
    }

    protected int getWater(int index) {
        Integer id;
        int res = -1;
        RCRSCSData<?> d = this.getData(DataType.WATER, index);
        if (d != null && (id = (Integer)((ValueData)d).getData()) != null) {
            res = id;
        }
        return res;
    }

    protected int getRepairCost(int index) {
        Integer id;
        int res = -1;
        RCRSCSData<?> d = this.getData(DataType.REPAIR_COST, index);
        if (d != null && (id = (Integer)((ValueData)d).getData()) != null) {
            res = id;
        }
        return res;
    }

    protected int getBrokenness(int index) {
        Integer id;
        int res = -1;
        RCRSCSData<?> d = this.getData(DataType.BROKENNESS, index);
        if (d != null && (id = (Integer)((ValueData)d).getData()) != null) {
            res = id;
        }
        return res;
    }

    protected Pair<Integer, Integer> getCoodinate(int index) {
        Integer x = null;
        Integer y = null;
        Pair res = null;
        RCRSCSData<?> d = this.getData(DataType.X_COORDINATE, index);
        if (d != null) {
            x = (Integer)((ValueData)d).getData();
        }
        if ((d = this.getData(DataType.Y_COORDINATE, index)) != null) {
            y = (Integer)((ValueData)d).getData();
        }
        res = new Pair((Object)x, (Object)y);
        return res;
    }

    protected List<EntityID> getEntityIDList(DataType type, int index) {
        List<Object> res = new ArrayList<EntityID>();
        RCRSCSData<?> d = this.getData(type, index);
        if (d != null && d instanceof EntityIDListData) {
            res = (List)((EntityIDListData)d).getData();
        }
        return res;
    }

    protected void setCoorinate(Pair<Integer, Integer> cor) {
        this.setData(new ValueData(DataType.X_COORDINATE, (Integer)cor.first()));
        this.setData(new ValueData(DataType.Y_COORDINATE, (Integer)cor.second()));
    }

    protected DataType[] getDataTypeArray() {
        DataType[] res = new DataType[this.data.size()];
        int len = COMMON_DATA_TYPE.length;
        System.arraycopy(COMMON_DATA_TYPE, 0, res, 0, len);
        System.arraycopy(this.messageType.getDataType(), 0, res, len, this.messageType.getDataType().length);
        return res;
    }
}

