/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import kernel.KernelState;
import kernel.TerminationCondition;
import rescuecore2.config.Config;
import rescuecore2.log.Logger;

public class TimestepTerminationCondition
implements TerminationCondition {
    private static final String TIMESTEPS_KEY = "kernel.timesteps";
    private int time;

    @Override
    public void initialise(Config config) {
        this.time = config.getIntValue(TIMESTEPS_KEY);
    }

    @Override
    public boolean shouldStop(KernelState state) {
        if (state.getTime() >= this.time) {
            Logger.info((String)("TimestepTerminationCondition fired: " + state.getTime() + " >= " + this.time));
            return true;
        }
        return false;
    }

    public String toString() {
        return "Timestep >= " + this.time + "";
    }
}

