/*
 * Decompiled with CFR 0.152.
 */
package kernel.ui;

import java.awt.GridLayout;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import rescuecore2.misc.gui.ListModelList;

public class ComponentManagerGUI
extends JPanel {
    private JList uncontrolledAgents;
    private JList agentAck;
    private JList simulatorAck;
    private JList viewerAck;
    private ListModelList<String> uncontrolledAgentsModel = new ListModelList();
    private ListModelList<String> agentAckModel = new ListModelList();
    private ListModelList<String> simulatorAckModel = new ListModelList();
    private ListModelList<String> viewerAckModel = new ListModelList();

    public ComponentManagerGUI() {
        super(new GridLayout(4, 1));
        this.uncontrolledAgents = new JList<String>((ListModel<String>)this.uncontrolledAgentsModel);
        this.agentAck = new JList<String>((ListModel<String>)this.agentAckModel);
        this.simulatorAck = new JList<String>((ListModel<String>)this.simulatorAckModel);
        this.viewerAck = new JList<String>((ListModel<String>)this.viewerAckModel);
        this.add(this.uncontrolledAgents, "Agents with no controller");
        this.add(this.agentAck, "Agents that have not acknowledged");
        this.add(this.simulatorAck, "Simulators that have not acknowledged");
        this.add(this.viewerAck, "Viewers that have not acknowledged");
    }

    public void updateUncontrolledAgents(final List<String> data) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComponentManagerGUI.this.uncontrolledAgentsModel.clear();
                ComponentManagerGUI.this.uncontrolledAgentsModel.addAll((Collection)data);
            }
        });
    }

    public void updateAgentAck(final List<String> data) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComponentManagerGUI.this.agentAckModel.clear();
                ComponentManagerGUI.this.agentAckModel.addAll((Collection)data);
            }
        });
    }

    public void updateSimulatorAck(final List<String> data) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComponentManagerGUI.this.simulatorAckModel.clear();
                ComponentManagerGUI.this.simulatorAckModel.addAll((Collection)data);
            }
        });
    }

    public void updateViewerAck(final List<String> data) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComponentManagerGUI.this.viewerAckModel.clear();
                ComponentManagerGUI.this.viewerAckModel.addAll((Collection)data);
            }
        });
    }

    private void add(JList list, String title) {
        JScrollPane scroll = new JScrollPane(list);
        scroll.setBorder(BorderFactory.createTitledBorder(title));
        this.add(scroll);
    }
}

