/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.Scenario;
import gis2.scenario.AbstractFunction;
import gis2.scenario.ScenarioEditor;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import maps.gml.GMLShape;
import rescuecore2.log.Logger;

public class PlaceAgentsFunction
extends AbstractFunction {
    private static final int TYPE_FIRE = 0;
    private static final int TYPE_POLICE = 1;
    private static final int TYPE_AMBULANCE = 2;
    private Random random = new Random();

    public PlaceAgentsFunction(ScenarioEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Place agents";
    }

    @Override
    public void execute() {
        JPanel panel = new JPanel(new GridLayout(3, 2));
        JTextField numberField = new JTextField("1");
        JComboBox<String> typeCombo = new JComboBox<String>(new String[]{"Fire", "Police", "Ambulance"});
        JCheckBox buildingBox = new JCheckBox("Place in buildings?", false);
        panel.add(new JLabel("Type"));
        panel.add(typeCombo);
        panel.add(new JLabel("Number"));
        panel.add(numberField);
        panel.add(buildingBox);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        int type = -1;
        ArrayList all = new ArrayList(this.editor.getMap().getRoads());
        if (JOptionPane.showConfirmDialog(null, panel, "Add agents", 2) == 0) {
            try {
                int number = Integer.parseInt(numberField.getText());
                type = typeCombo.getSelectedIndex();
                boolean buildings = buildingBox.isSelected();
                if (buildings) {
                    all.addAll(this.editor.getMap().getBuildings());
                }
                for (int i = 0; i < number; ++i) {
                    ids.add(((GMLShape)all.get(this.random.nextInt(all.size()))).getID());
                }
            }
            catch (NumberFormatException e) {
                Logger.error((String)"Error parsing number", (Throwable)e);
            }
        }
        Scenario s = this.editor.getScenario();
        switch (type) {
            case 0: {
                int id;
                Iterator i$ = ids.iterator();
                while (i$.hasNext()) {
                    id = (Integer)i$.next();
                    s.addFireBrigade(id);
                }
                break;
            }
            case 1: {
                int id;
                Iterator i$ = ids.iterator();
                while (i$.hasNext()) {
                    id = (Integer)i$.next();
                    s.addPoliceForce(id);
                }
                break;
            }
            case 2: {
                int id;
                Iterator i$ = ids.iterator();
                while (i$.hasNext()) {
                    id = (Integer)i$.next();
                    s.addAmbulanceTeam(id);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected type: " + type);
            }
        }
        this.editor.setChanged();
        this.editor.updateOverlays();
    }
}

