/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.scenario.ScenarioEditor;
import gis2.scenario.ShapeTool;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLBuilding;
import maps.gml.GMLShape;

public class PlaceRefugeTool
extends ShapeTool {
    public PlaceRefugeTool(ScenarioEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Place refuge";
    }

    @Override
    protected boolean shouldHighlight(GMLShape shape) {
        return shape instanceof GMLBuilding;
    }

    @Override
    protected void processClick(GMLShape shape) {
        this.editor.getScenario().addRefuge(shape.getID());
        this.editor.setChanged();
        this.editor.updateOverlays();
        this.editor.addEdit(new AddRefugeEdit(shape.getID()));
    }

    private class AddRefugeEdit
    extends AbstractUndoableEdit {
        private int id;

        public AddRefugeEdit(int id) {
            this.id = id;
        }

        @Override
        public void undo() {
            super.undo();
            PlaceRefugeTool.this.editor.getScenario().removeRefuge(this.id);
            PlaceRefugeTool.this.editor.updateOverlays();
        }

        @Override
        public void redo() {
            super.redo();
            PlaceRefugeTool.this.editor.getScenario().addRefuge(this.id);
            PlaceRefugeTool.this.editor.updateOverlays();
        }
    }
}

