/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.scenario.ScenarioEditor;
import gis2.scenario.ShapeTool;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLBuilding;
import maps.gml.GMLShape;

public class RemoveAmbulanceCentreTool
extends ShapeTool {
    public RemoveAmbulanceCentreTool(ScenarioEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Remove ambulance centre";
    }

    @Override
    protected boolean shouldHighlight(GMLShape shape) {
        return shape instanceof GMLBuilding;
    }

    @Override
    protected void processClick(GMLShape shape) {
        this.editor.getScenario().removeAmbulanceCentre(shape.getID());
        this.editor.setChanged();
        this.editor.updateOverlays();
        this.editor.addEdit(new RemoveAmbulanceCentreEdit(shape.getID()));
    }

    private class RemoveAmbulanceCentreEdit
    extends AbstractUndoableEdit {
        private int id;

        public RemoveAmbulanceCentreEdit(int id) {
            this.id = id;
        }

        @Override
        public void undo() {
            super.undo();
            RemoveAmbulanceCentreTool.this.editor.getScenario().addAmbulanceCentre(this.id);
            RemoveAmbulanceCentreTool.this.editor.updateOverlays();
        }

        @Override
        public void redo() {
            super.redo();
            RemoveAmbulanceCentreTool.this.editor.getScenario().removeAmbulanceCentre(this.id);
            RemoveAmbulanceCentreTool.this.editor.updateOverlays();
        }
    }
}

