/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.scenario.ScenarioEditor;
import gis2.scenario.ShapeTool;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLShape;

public class RemoveAmbulanceTeamTool
extends ShapeTool {
    public RemoveAmbulanceTeamTool(ScenarioEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Remove ambulance team";
    }

    @Override
    protected boolean shouldHighlight(GMLShape shape) {
        return true;
    }

    @Override
    protected void processClick(GMLShape shape) {
        this.editor.getScenario().removeAmbulanceTeam(shape.getID());
        this.editor.setChanged();
        this.editor.updateOverlays();
        this.editor.addEdit(new RemoveAmbulanceTeamEdit(shape.getID()));
    }

    private class RemoveAmbulanceTeamEdit
    extends AbstractUndoableEdit {
        private int id;

        public RemoveAmbulanceTeamEdit(int id) {
            this.id = id;
        }

        @Override
        public void undo() {
            super.undo();
            RemoveAmbulanceTeamTool.this.editor.getScenario().addAmbulanceTeam(this.id);
            RemoveAmbulanceTeamTool.this.editor.updateOverlays();
        }

        @Override
        public void redo() {
            super.redo();
            RemoveAmbulanceTeamTool.this.editor.getScenario().removeAmbulanceTeam(this.id);
            RemoveAmbulanceTeamTool.this.editor.updateOverlays();
        }
    }
}

