/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.legacy2gml;

import java.io.File;
import java.util.HashMap;
import maps.ScaleConversion;
import maps.convert.legacy2gml.BuildingInfo;
import maps.convert.legacy2gml.NodeInfo;
import maps.convert.legacy2gml.RoadInfo;
import maps.gml.GMLMap;
import maps.gml.formats.RobocupFormat;
import maps.legacy.LegacyBuilding;
import maps.legacy.LegacyMap;
import maps.legacy.LegacyMapFormat;
import maps.legacy.LegacyNode;
import maps.legacy.LegacyRoad;
import rescuecore2.log.Logger;

public final class LegacyToGML {
    private static final double MM_TO_M = 0.001;

    private LegacyToGML() {
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: LegacyToGML <legacy-mapdir> <gml-mapname>");
            return;
        }
        try {
            Logger.info((String)"Reading legacy map");
            LegacyMap legacy = LegacyMapFormat.INSTANCE.read(new File(args[0]));
            GMLMap gml = new GMLMap();
            Logger.info((String)"Converting");
            LegacyToGML.convert(legacy, gml);
            Logger.info((String)"Writing GML map");
            RobocupFormat.INSTANCE.write(gml, new File(args[1]));
            Logger.info((String)"Done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private static void convert(LegacyMap legacy, GMLMap gml) {
        HashMap<Integer, RoadInfo> roadInfo = new HashMap<Integer, RoadInfo>();
        HashMap<Integer, NodeInfo> nodeInfo = new HashMap<Integer, NodeInfo>();
        HashMap<Integer, BuildingInfo> buildingInfo = new HashMap<Integer, BuildingInfo>();
        Logger.debug((String)"Reading roads");
        for (LegacyRoad legacyRoad : legacy.getRoads()) {
            roadInfo.put(legacyRoad.getID(), new RoadInfo());
        }
        Logger.debug((String)"Reading nodes");
        for (LegacyNode legacyNode : legacy.getNodes()) {
            nodeInfo.put(legacyNode.getID(), new NodeInfo(legacyNode));
        }
        Logger.debug((String)"Reading buildings");
        for (LegacyBuilding legacyBuilding : legacy.getBuildings()) {
            buildingInfo.put(legacyBuilding.getID(), new BuildingInfo(legacyBuilding));
        }
        Logger.debug((String)"Creating intersections");
        for (NodeInfo nodeInfo2 : nodeInfo.values()) {
            nodeInfo2.process(legacy, gml, roadInfo);
        }
        Logger.debug((String)"Creating roads");
        for (RoadInfo roadInfo2 : roadInfo.values()) {
            roadInfo2.process(gml);
        }
        Logger.debug((String)"Creating buildings");
        for (BuildingInfo buildingInfo2 : buildingInfo.values()) {
            buildingInfo2.process(gml, nodeInfo, roadInfo);
        }
        gml.convertCoordinates(new ScaleConversion(gml.getMinX(), gml.getMinY(), 0.001, 0.001));
    }
}

