/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.osm2gml;

import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import maps.convert.ConvertStep;
import maps.convert.osm2gml.Constants;
import maps.convert.osm2gml.ConvertTools;
import maps.convert.osm2gml.TemporaryMap;
import maps.convert.osm2gml.TemporaryObject;
import maps.convert.osm2gml.TemporaryObjectInfo;
import rescuecore2.log.Logger;
import rescuecore2.misc.gui.ShapeDebugFrame;

public class RemoveShapesStep
extends ConvertStep {
    private TemporaryMap map;

    public RemoveShapesStep(TemporaryMap map) {
        this.map = map;
    }

    @Override
    public String getDescription() {
        return "Removing extraneous shapes";
    }

    @Override
    protected void step() {
        this.debug.setBackground(ConvertTools.getAllDebugShapes(this.map));
        this.debug.setAutozoomEnabled(false);
        Collection<TemporaryObject> allObjects = this.map.getAllObjects();
        this.setProgressLimit(allObjects.size() * 2);
        HashSet<TemporaryObject> removed = new HashSet<TemporaryObject>();
        this.setStatus("Removing duplicate shapes");
        int duplicateCount = 0;
        int interiorCount = 0;
        Logger.debug((String)"Removing building duplicates");
        duplicateCount += this.removeDuplicates(this.map.getBuildings(), removed, allObjects);
        Logger.debug((String)"Removing intersection duplicates");
        duplicateCount += this.removeDuplicates(this.map.getIntersections(), removed, allObjects);
        Logger.debug((String)"Removing road duplicates");
        Logger.debug((String)"Removing interior faces");
        this.setStatus("Removing interior faces");
        interiorCount += this.removeInterior(this.map.getRoads(), removed, allObjects);
        interiorCount += this.removeInterior(this.map.getIntersections(), removed, allObjects);
        this.setStatus("Removed " + removed.size() + " faces: " + (duplicateCount += this.removeDuplicates(this.map.getRoads(), removed, allObjects)) + " duplicates and " + (interiorCount += this.removeInterior(this.map.getBuildings(), removed, allObjects)) + " interior");
        this.debug.clearBackground();
        this.debug.activate();
        this.debug.show("Result", ConvertTools.getAllDebugShapes(this.map));
    }

    private int removeDuplicates(Collection<? extends TemporaryObject> test, Set<TemporaryObject> removed, Collection<TemporaryObject> toCheck) {
        int count = 0;
        Logger.debug((String)(test.size() + " test objects, " + toCheck.size() + " to check, " + removed.size() + " already removed"));
        for (TemporaryObject temporaryObject : test) {
            this.bumpProgress();
            if (removed.contains(temporaryObject)) continue;
            Logger.debug((String)("Next test object: " + temporaryObject));
            for (TemporaryObject second : toCheck) {
                if (removed.contains(second) || temporaryObject == second) continue;
                Logger.debug((String)("Next check object: " + second));
                if (temporaryObject.isDuplicate(second)) {
                    this.map.removeTemporaryObject(second);
                    removed.add(second);
                    ++count;
                    Logger.debug((String)("Removed duplicate object: " + second + " is same as " + temporaryObject));
                }
                this.debug.show("Checking for duplicates", new ShapeDebugFrame.ShapeInfo[]{new TemporaryObjectInfo(temporaryObject, "First", Color.WHITE, Constants.TRANSPARENT_LIME), new TemporaryObjectInfo(second, "Second", Color.WHITE, Constants.TRANSPARENT_BLUE)});
            }
        }
        return count;
    }

    private int removeInterior(Collection<? extends TemporaryObject> toCheck, Set<TemporaryObject> removed, Collection<TemporaryObject> allObjects) {
        int count = 0;
        for (TemporaryObject temporaryObject : toCheck) {
            this.bumpProgress();
            if (removed.contains(temporaryObject)) continue;
            for (TemporaryObject second : allObjects) {
                if (removed.contains(second) || temporaryObject == second || !temporaryObject.isEntirelyInside(second)) continue;
                this.map.removeTemporaryObject(temporaryObject);
                removed.add(temporaryObject);
                ++count;
            }
        }
        return count;
    }
}

