/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import maps.gml.GMLCoordinates;
import maps.gml.GMLNode;
import maps.gml.editor.AbstractTool;
import maps.gml.editor.GMLEditor;
import maps.gml.view.NodeDecorator;
import maps.gml.view.SquareNodeDecorator;

public class MergeNodesTool
extends AbstractTool {
    private static final Color HOVER_COLOUR = Color.BLUE;
    private static final Color MERGE_COLOUR = Color.RED;
    private static final int HIGHLIGHT_SIZE = 6;
    private Listener listener = new Listener();
    private NodeDecorator hoverHighlight = new SquareNodeDecorator(HOVER_COLOUR, 6);
    private NodeDecorator mergeHighlight = new SquareNodeDecorator(MERGE_COLOUR, 6);
    private GMLNode hover;
    private GMLNode merge;
    private boolean merging;

    public MergeNodesTool(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Merge nodes";
    }

    @Override
    public void activate() {
        this.editor.getViewer().addMouseListener(this.listener);
        this.editor.getViewer().addMouseMotionListener(this.listener);
        this.hover = null;
        this.merge = null;
        this.merging = false;
    }

    @Override
    public void deactivate() {
        this.editor.getViewer().removeMouseListener(this.listener);
        this.editor.getViewer().removeMouseMotionListener(this.listener);
        this.editor.getViewer().clearAllNodeDecorators();
        this.editor.getViewer().repaint();
    }

    private void hover(GMLNode node) {
        if (this.hover == node) {
            return;
        }
        if (this.hover != null) {
            this.editor.getViewer().clearNodeDecorator(this.hover);
        }
        this.hover = node;
        if (this.hover != null) {
            this.editor.getViewer().setNodeDecorator(this.hoverHighlight, this.hover);
        }
        this.editor.getViewer().repaint();
    }

    private void setMerge(GMLNode node) {
        if (this.merge == node) {
            return;
        }
        if (node == this.hover) {
            return;
        }
        if (this.merge != null) {
            this.editor.getViewer().clearNodeDecorator(this.merge);
        }
        this.merge = node;
        if (this.merge != null) {
            this.editor.getViewer().setNodeDecorator(this.mergeHighlight, this.merge);
        }
        this.editor.getViewer().repaint();
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p = this.fixEventPoint(e.getPoint());
            GMLCoordinates c = MergeNodesTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y);
            GMLNode node = MergeNodesTool.this.editor.getMap().findNearestNode(c.getX(), c.getY());
            MergeNodesTool.this.hover(node);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (MergeNodesTool.this.hover == null) {
                return;
            }
            if (!MergeNodesTool.this.merging) {
                return;
            }
            Point p = this.fixEventPoint(e.getPoint());
            GMLCoordinates c = MergeNodesTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y);
            GMLNode node = MergeNodesTool.this.editor.getMap().findNearestNode(c.getX(), c.getY());
            MergeNodesTool.this.setMerge(node);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1 && MergeNodesTool.this.merging) {
                if (MergeNodesTool.this.hover != null && MergeNodesTool.this.merge != null) {
                    MergeNodesTool.this.editor.getMap().replaceNode(MergeNodesTool.this.hover, MergeNodesTool.this.merge);
                    MergeNodesTool.this.editor.getMap().removeNode(MergeNodesTool.this.hover);
                    MergeNodesTool.this.editor.setChanged();
                }
                if (MergeNodesTool.this.hover != null) {
                    MergeNodesTool.this.editor.getViewer().clearNodeDecorator(MergeNodesTool.this.hover);
                }
                if (MergeNodesTool.this.merge != null) {
                    MergeNodesTool.this.editor.getViewer().clearNodeDecorator(MergeNodesTool.this.merge);
                }
                MergeNodesTool.this.editor.getViewer().repaint();
                MergeNodesTool.this.hover = null;
                MergeNodesTool.this.merge = null;
                MergeNodesTool.this.merging = false;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                MergeNodesTool.this.merging = true;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private Point fixEventPoint(Point p) {
            Insets insets = MergeNodesTool.this.editor.getViewer().getInsets();
            return new Point(p.x - insets.left, p.y - insets.top);
        }
    }
}

