/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import maps.gml.GMLDirectedEdge;
import maps.gml.GMLEdge;
import maps.gml.GMLMap;
import maps.gml.GMLNode;
import maps.gml.GMLObject;
import maps.gml.GMLShape;

public class GMLObjectInspector
extends JPanel {
    private static final int NODE_ROW_ID = 0;
    private static final int NODE_ROW_X = 1;
    private static final int NODE_ROW_Y = 2;
    private static final int NODE_ROW_ATTACHED_EDGES = 3;
    private static final int NODE_ROWS = 4;
    private static final int EDGE_ROW_ID = 0;
    private static final int EDGE_ROW_START = 1;
    private static final int EDGE_ROW_END = 2;
    private static final int EDGE_ROW_PASSABLE = 3;
    private static final int EDGE_ROW_ATTACHED_SHAPES = 4;
    private static final int EDGE_ROWS = 5;
    private static final int SHAPE_ROW_ID = 0;
    private static final int SHAPE_ROW_EDGE_COUNT = 1;
    private static final int SHAPE_BASE_ROWS = 2;
    private static final TableModel EMPTY_MODEL = new AbstractTableModel(){

        @Override
        public int getRowCount() {
            return 0;
        }

        @Override
        public int getColumnCount() {
            return 0;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return null;
        }
    };
    private GMLMap map;
    private JTable table;
    private NodeTableModel nodeModel;
    private EdgeTableModel edgeModel;
    private ShapeTableModel shapeModel;

    public GMLObjectInspector(GMLMap map) {
        super(new BorderLayout());
        this.map = map;
        this.nodeModel = new NodeTableModel();
        this.edgeModel = new EdgeTableModel();
        this.shapeModel = new ShapeTableModel();
        this.table = new JTable();
        JScrollPane scroll = new JScrollPane(this.table);
        this.add((Component)scroll, "Center");
    }

    public void setMap(GMLMap newMap) {
        this.map = newMap;
    }

    public void inspect(GMLNode node) {
        this.table.setModel(this.nodeModel);
        this.nodeModel.show(node);
    }

    public void inspect(GMLEdge edge) {
        this.table.setModel(this.edgeModel);
        this.edgeModel.show(edge);
    }

    public void inspect(GMLShape shape) {
        this.table.setModel(this.shapeModel);
        this.shapeModel.show(shape);
    }

    public void inspect(GMLObject object) {
        if (object == null) {
            this.table.setModel(EMPTY_MODEL);
        } else if (object instanceof GMLNode) {
            this.inspect((GMLNode)object);
        } else if (object instanceof GMLEdge) {
            this.inspect((GMLEdge)object);
        } else if (object instanceof GMLShape) {
            this.inspect((GMLShape)object);
        } else {
            throw new IllegalArgumentException("Don't know how to inspect " + object);
        }
    }

    private static class ShapeTableModel
    extends AbstractTableModel {
        private GMLShape shape;

        private ShapeTableModel() {
        }

        void show(GMLShape s) {
            this.shape = s;
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return 2 + (this.shape == null ? 0 : this.shape.getEdges().size());
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                switch (row) {
                    case 0: {
                        return "Shape ID";
                    }
                    case 1: {
                        return "Number of edges";
                    }
                }
                return "Edge " + (row - 2 + 1);
            }
            if (col == 1) {
                if (this.shape == null) {
                    return null;
                }
                switch (row) {
                    case 0: {
                        return this.shape.getID();
                    }
                    case 1: {
                        return this.shape.getEdges().size();
                    }
                }
                List<GMLDirectedEdge> edges = this.shape.getEdges();
                int index = row - 2;
                if (index < 0 || index >= edges.size()) {
                    throw new IllegalArgumentException("Invalid row: " + row);
                }
                return edges.get(index);
            }
            throw new IllegalArgumentException("Unrecognised column: " + col);
        }
    }

    private class EdgeTableModel
    extends AbstractTableModel {
        private GMLEdge edge;

        private EdgeTableModel() {
        }

        void show(GMLEdge e) {
            this.edge = e;
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return 5;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                switch (row) {
                    case 0: {
                        return "Edge ID";
                    }
                    case 1: {
                        return "Start node";
                    }
                    case 2: {
                        return "End node";
                    }
                    case 3: {
                        return "Passable";
                    }
                    case 4: {
                        return "Attached shapes";
                    }
                }
                throw new IllegalArgumentException("Unrecognised row: " + row);
            }
            if (col == 1) {
                if (this.edge == null) {
                    return null;
                }
                switch (row) {
                    case 0: {
                        return this.edge.getID();
                    }
                    case 1: {
                        return this.edge.getStart().getID();
                    }
                    case 2: {
                        return this.edge.getEnd().getID();
                    }
                    case 3: {
                        return this.edge.isPassable();
                    }
                    case 4: {
                        if (GMLObjectInspector.this.map == null) {
                            return "";
                        }
                        Collection<GMLShape> attached = GMLObjectInspector.this.map.getAttachedShapes(this.edge);
                        StringBuilder result = new StringBuilder();
                        for (GMLShape next : attached) {
                            result.append(next.toString());
                            result.append("  ");
                        }
                        return result.toString();
                    }
                }
                throw new IllegalArgumentException("Unrecognised row: " + row);
            }
            throw new IllegalArgumentException("Unrecognised column: " + col);
        }
    }

    private class NodeTableModel
    extends AbstractTableModel {
        private GMLNode node;

        private NodeTableModel() {
        }

        void show(GMLNode n) {
            this.node = n;
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return 4;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                switch (row) {
                    case 0: {
                        return "Node ID";
                    }
                    case 1: {
                        return "X";
                    }
                    case 2: {
                        return "Y";
                    }
                    case 3: {
                        return "Attached edges";
                    }
                }
                throw new IllegalArgumentException("Unrecognised row: " + row);
            }
            if (col == 1) {
                if (this.node == null) {
                    return null;
                }
                switch (row) {
                    case 0: {
                        return this.node.getID();
                    }
                    case 1: {
                        return this.node.getX();
                    }
                    case 2: {
                        return this.node.getY();
                    }
                    case 3: {
                        if (GMLObjectInspector.this.map == null) {
                            return "";
                        }
                        Collection<GMLEdge> attached = GMLObjectInspector.this.map.getAttachedEdges(this.node);
                        StringBuilder result = new StringBuilder();
                        for (GMLEdge next : attached) {
                            result.append(next.toString());
                            result.append("  ");
                        }
                        return result.toString();
                    }
                }
                throw new IllegalArgumentException("Unrecognised row: " + row);
            }
            throw new IllegalArgumentException("Unrecognised column: " + col);
        }
    }
}

