/*
 * Decompiled with CFR 0.152.
 */
package maps.legacy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import maps.Map;
import maps.legacy.LegacyBuilding;
import maps.legacy.LegacyNode;
import maps.legacy.LegacyRoad;
import rescuecore2.log.Logger;
import rescuecore2.misc.EncodingTools;

public class LegacyMap
implements Map {
    private java.util.Map<Integer, LegacyNode> nodes = new HashMap<Integer, LegacyNode>();
    private java.util.Map<Integer, LegacyRoad> roads = new HashMap<Integer, LegacyRoad>();
    private java.util.Map<Integer, LegacyBuilding> buildings = new HashMap<Integer, LegacyBuilding>();

    public LegacyMap() {
    }

    public LegacyMap(File baseDir) throws IOException {
        this();
        this.read(baseDir);
    }

    public void read(File baseDir) throws IOException {
        this.nodes.clear();
        this.roads.clear();
        this.buildings.clear();
        this.readNodes(baseDir);
        this.readRoads(baseDir);
        this.readBuildings(baseDir);
    }

    public Collection<LegacyRoad> getRoads() {
        return Collections.unmodifiableCollection(this.roads.values());
    }

    public LegacyRoad getRoad(int id) {
        return this.roads.get(id);
    }

    public Collection<LegacyNode> getNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    public LegacyNode getNode(int id) {
        return this.nodes.get(id);
    }

    public Collection<LegacyBuilding> getBuildings() {
        return Collections.unmodifiableCollection(this.buildings.values());
    }

    public LegacyBuilding getBuilding(int id) {
        return this.buildings.get(id);
    }

    private void readNodes(File baseDir) throws IOException {
        File f = new File(baseDir, "node.bin");
        FileInputStream in = new FileInputStream(f);
        EncodingTools.reallySkip((InputStream)in, (long)12L);
        int num = EncodingTools.readInt32LE((InputStream)in);
        Logger.debug((String)("Reading " + num + " nodes"));
        for (int i = 0; i < num; ++i) {
            LegacyNode node = new LegacyNode();
            node.read(in);
            this.nodes.put(node.getID(), node);
        }
    }

    private void readRoads(File baseDir) throws IOException {
        File f = new File(baseDir, "road.bin");
        FileInputStream in = new FileInputStream(f);
        EncodingTools.reallySkip((InputStream)in, (long)12L);
        int num = EncodingTools.readInt32LE((InputStream)in);
        Logger.debug((String)("Reading " + num + " roads"));
        for (int i = 0; i < num; ++i) {
            LegacyRoad road = new LegacyRoad();
            road.read(in);
            this.roads.put(road.getID(), road);
        }
    }

    private void readBuildings(File baseDir) throws IOException {
        File f = new File(baseDir, "building.bin");
        FileInputStream in = new FileInputStream(f);
        EncodingTools.reallySkip((InputStream)in, (long)12L);
        int num = EncodingTools.readInt32LE((InputStream)in);
        Logger.debug((String)("Reading " + num + " buildings"));
        for (int i = 0; i < num; ++i) {
            LegacyBuilding building = new LegacyBuilding();
            building.read(in);
            this.buildings.put(building.getID(), building);
        }
    }
}

