/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class VertexTaggedGeometryDataMapper {
    private Map coordDataMap = new TreeMap();

    public void loadSourceGeometries(Collection geoms) {
        Iterator i = geoms.iterator();
        while (i.hasNext()) {
            Geometry geom = (Geometry)i.next();
            this.loadVertices(geom.getCoordinates(), geom.getUserData());
        }
    }

    public void loadSourceGeometries(Geometry geomColl) {
        for (int i = 0; i < geomColl.getNumGeometries(); ++i) {
            Geometry geom = geomColl.getGeometryN(i);
            this.loadVertices(geom.getCoordinates(), geom.getUserData());
        }
    }

    private void loadVertices(Coordinate[] pts, Object data) {
        for (int i = 0; i < pts.length; ++i) {
            this.coordDataMap.put(pts[i], data);
        }
    }

    public List getCoordinates() {
        return new ArrayList(this.coordDataMap.keySet());
    }

    public void transferData(Geometry targetGeom) {
        for (int i = 0; i < targetGeom.getNumGeometries(); ++i) {
            Geometry geom = targetGeom.getGeometryN(i);
            Coordinate vertexKey = (Coordinate)geom.getUserData();
            if (vertexKey == null) continue;
            geom.setUserData(this.coordDataMap.get(vertexKey));
        }
    }
}

