/*
 * Decompiled with CFR 0.152.
 */
package firesimulator.world;

import firesimulator.simulator.Simulator;
import firesimulator.util.Geometry;
import firesimulator.world.StationaryObject;
import firesimulator.world.Wall;
import firesimulator.world.World;
import java.awt.Polygon;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.uncommons.maths.number.NumberGenerator;

public class Building
extends StationaryObject {
    private static final Log LOG = LogFactory.getLog(Building.class);
    private static final double STEFAN_BOLTZMANN_CONSTANT = 5.6704E-8;
    public static int WATER_EXTINGUISH_PARAM;
    public static float woodSpeed;
    public static float steelSpeed;
    public static float concreteSpeed;
    public static float WATER_CAPCITY;
    public static boolean POLICE_INFALMEABLE;
    public static boolean AMBULANCE_INFALMEABLE;
    public static boolean FIRE_INFALMEABLE;
    public static boolean REFUGE_INFALMEABLE;
    public static NumberGenerator<Double> burnRate;
    public boolean fierynessChanged;
    private int waterQuantity;
    private int floors = 1;
    private int attributes = 0;
    private int ignition = 0;
    protected int fieryness = 0;
    private int brokenness = 0;
    public int[][] cells;
    private int[] entrances;
    private int code = 0;
    private float buildingAreaGround = 0.0f;
    private float buildingAreaTotal = 0.0f;
    private int[] apexes;
    private Polygon polygon = null;
    public float fuel;
    private float initFuel = -1.0f;
    private float prevBurned = 0.0f;
    public float volume;
    public float capacity;
    private double energy;
    static final int FLOOR_HEIGHT = 3;
    public float cooling = 0.0f;
    public Collection walls;
    public Hashtable connectedBuildings = new Hashtable(30);
    public Building[] connectedBuilding;
    public float[] connectedValues;
    public double totalWallArea;
    private int lwater = 0;
    private int lwTime = -1;
    private boolean wasEverWatered = false;
    public boolean inflameable = true;
    public static float woodCapacity;
    public static float steelCapacity;
    public static float concreteCapacity;
    public static float woodIgnition;
    public static float steelIgnition;
    public static float concreteIgnition;
    public static float woodEnergie;
    public static float steelEnergie;
    public static float concreteEnergie;
    public static float woodBurning;
    public static float steelBurning;
    public static float concreteBurning;
    public static final int NORMAL = 0;
    public static final int HEATING = 1;
    public static final int BURNING = 2;
    public static final int COOLING_DOWN = 3;
    public static final int EXTINGUISHED = 5;
    public static final int BURNED_DOWN = 4;

    public Building(int id) {
        super(id);
    }

    public float getBurningTemp() {
        switch (this.code) {
            case 0: {
                return woodBurning;
            }
            case 1: {
                return steelBurning;
            }
        }
        return concreteBurning;
    }

    public float getIgnitionPoint() {
        switch (this.code) {
            case 0: {
                return woodIgnition;
            }
            case 1: {
                return steelIgnition;
            }
        }
        return concreteIgnition;
    }

    public void ignite() {
        this.energy = (double)(this.getCapacity() * this.getIgnitionPoint()) * 1.5;
    }

    public float getBuildingAreaGround() {
        return this.buildingAreaGround;
    }

    public int getFloors() {
        return this.floors;
    }

    public void initialize(World world) {
        this.initWalls(world);
        this.setFieryness(0);
        this.setWaterQuantity(0);
        this.fierynessChanged = false;
        if (this.polygon == null) {
            this.polygon = new Polygon();
            for (int n = 0; n < this.apexes.length; ++n) {
                this.polygon.addPoint(this.apexes[n], this.apexes[++n]);
            }
        }
        this.volume = this.buildingAreaGround * (float)this.floors * 3.0f;
        this.fuel = this.getInitialFuel();
        this.setCapacity(this.volume * this.getThermoCapacity());
        this.energy = 0.0;
        this.initFuel = -1.0f;
        this.prevBurned = 0.0f;
        this.lwTime = -1;
        this.lwater = 0;
        this.wasEverWatered = false;
        LOG.debug((Object)("Initialised building " + this.id + ": ground area = " + this.buildingAreaGround + ", floors = " + this.floors + ", volume = " + this.volume + ", initial fuel = " + this.fuel + ", energy capacity = " + this.getCapacity()));
    }

    public void reset(World w) {
        this.setFieryness(0);
        this.setWaterQuantity(0);
        this.initialize(w);
    }

    private void initWalls(World world) {
        if (this.walls != null) {
            return;
        }
        this.totalWallArea = 0.0;
        this.walls = new LinkedList();
        int fx = this.apexes[0];
        int fy = this.apexes[1];
        int lx = fx;
        int ly = fy;
        for (int n = 2; n < this.apexes.length; ++n) {
            int ty;
            Wall w;
            int tx = this.apexes[n];
            if ((w = new Wall(lx, ly, tx, ty = this.apexes[++n], this)).validate()) {
                this.walls.add(w);
                this.totalWallArea += 3000.0 * w.length;
            } else {
                LOG.warn((Object)("Ignoring odd wall at building " + this.getID()));
            }
            lx = tx;
            ly = ty;
        }
        Wall w = new Wall(lx, ly, fx, fy, this);
        this.walls.add(w);
        world.allWalls.addAll(this.walls);
        this.totalWallArea /= 1000000.0;
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    public void initWallValues(World world) {
        int totalHits = 0;
        int totalRays = 0;
        int selfHits = 0;
        int strange = 0;
        for (Wall wall : this.walls) {
            wall.findHits(world);
            totalHits += wall.hits;
            selfHits += wall.selfHits;
            totalRays += wall.rays;
            strange = wall.strange;
        }
        int c = 0;
        this.connectedBuilding = new Building[this.connectedBuildings.size()];
        this.connectedValues = new float[this.connectedBuildings.size()];
        float base = totalRays;
        Enumeration e = this.connectedBuildings.keys();
        while (e.hasMoreElements()) {
            Building b = (Building)e.nextElement();
            Integer value = (Integer)this.connectedBuildings.get(b);
            this.connectedBuilding[c] = b;
            this.connectedValues[c] = value.floatValue() / base;
            ++c;
        }
        LOG.debug((Object)("{" + (float)totalHits * 100.0f / (float)totalRays + "," + totalRays + "," + totalHits + "," + selfHits + "," + strange + "}"));
    }

    public float getInitialFuel() {
        if (this.initFuel < 0.0f) {
            this.initFuel = this.getFuelDensity() * this.volume;
        }
        return this.initFuel;
    }

    private float getFuelDensity() {
        switch (this.code) {
            case 0: {
                return woodEnergie;
            }
            case 1: {
                return steelEnergie;
            }
        }
        return concreteEnergie;
    }

    private float getThermoCapacity() {
        switch (this.code) {
            case 0: {
                return woodCapacity;
            }
            case 1: {
                return steelCapacity;
            }
        }
        return concreteCapacity;
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    @Override
    public String getType() {
        return "BUILDING";
    }

    public void setAttributes(int atrb) {
        this.attributes = atrb;
    }

    public int getCode() {
        return this.code;
    }

    public void setIgnition(int ignition) {
        this.ignition = ignition;
    }

    public int getIgnition() {
        return this.ignition;
    }

    public void setFieryness(int fieryness) {
        this.fieryness = fieryness;
    }

    public float getFuel() {
        return this.fuel;
    }

    public int getFieryness() {
        if (!this.isInflameable()) {
            return 0;
        }
        if (this.getTemperature() >= (double)this.getIgnitionPoint()) {
            if ((double)this.fuel >= (double)this.getInitialFuel() * 0.66) {
                return 1;
            }
            if ((double)this.fuel >= (double)this.getInitialFuel() * 0.33) {
                return 2;
            }
            if (this.fuel > 0.0f) {
                return 3;
            }
        }
        if (this.fuel == this.getInitialFuel()) {
            if (this.wasEverWatered) {
                return 4;
            }
            return 0;
        }
        if ((double)this.fuel >= (double)this.getInitialFuel() * 0.66) {
            return 5;
        }
        if ((double)this.fuel >= (double)this.getInitialFuel() * 0.33) {
            return 6;
        }
        if (this.fuel > 0.0f) {
            return 7;
        }
        return 8;
    }

    public void setBrokenness(int brk) {
        this.brokenness = brk;
    }

    public void setEntrances(int[] ent) {
        this.entrances = ent;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setBuildingAreaGround(float area) {
        this.buildingAreaGround = area;
    }

    public void setBuildingAreaTotal(float area) {
        this.buildingAreaTotal = area;
    }

    public void setApexes(int[] apx) {
        this.apexes = apx;
    }

    public int[] getApexes() {
        return this.apexes;
    }

    public void setFloors(int floors) {
        this.floors = floors;
    }

    public void findCells(World w) {
        LinkedList<Integer> tmp = new LinkedList<Integer>();
        for (int x = 0; x < w.getAirTemp().length; ++x) {
            for (int y = 0; y < w.getAirTemp()[0].length; ++y) {
                int pc;
                int yv;
                int xv = x * w.SAMPLE_SIZE + w.getMinX();
                if (!Geometry.boundingTest(this.polygon, xv, yv = y * w.SAMPLE_SIZE + w.getMinY(), w.SAMPLE_SIZE, w.SAMPLE_SIZE) || (pc = Geometry.percent(xv, yv, w.SAMPLE_SIZE, w.SAMPLE_SIZE, this.polygon)) <= 0) continue;
                tmp.add(new Integer(x));
                tmp.add(new Integer(y));
                tmp.add(new Integer(pc));
                Object[] o = new Object[]{this, new Float(pc)};
                w.gridToBuilding[x][y].add(o);
            }
        }
        if (tmp.size() > 0) {
            this.cells = new int[tmp.size() / 3][3];
            Iterator i = tmp.iterator();
            for (int c = 0; c < this.cells.length; ++c) {
                this.cells[c][0] = (Integer)i.next();
                this.cells[c][1] = (Integer)i.next();
                this.cells[c][2] = (Integer)i.next();
            }
        } else {
            LOG.warn((Object)(this.getID() + " has no cell"));
            LOG.warn((Object)("Sample size: " + w.SAMPLE_SIZE));
            LOG.warn((Object)("World min X, Y: " + w.getMinX() + ", " + w.getMinY()));
            LOG.warn((Object)("Air grid size: " + w.getAirTemp().length + " x " + w.getAirTemp()[0].length));
            LOG.warn((Object)"Building polygon: ");
            for (int i = 0; i < this.apexes.length; i += 2) {
                LOG.warn((Object)(this.apexes[i] + ", " + this.apexes[i + 1]));
            }
            int expectedCellX = (this.apexes[0] - w.getMinX()) / w.SAMPLE_SIZE;
            int expectedCellY = (this.apexes[1] - w.getMinY()) / w.SAMPLE_SIZE;
            LOG.warn((Object)("Building should be in cell " + expectedCellX + ", " + expectedCellY));
            for (int x = 0; x < w.getAirTemp().length; ++x) {
                for (int y = 0; y < w.getAirTemp()[0].length; ++y) {
                    int yv;
                    int xv = x * w.SAMPLE_SIZE + w.getMinX();
                    if (!Geometry.boundingTest(this.polygon, xv, yv = y * w.SAMPLE_SIZE + w.getMinY(), w.SAMPLE_SIZE, w.SAMPLE_SIZE)) continue;
                    LOG.warn((Object)("Cell " + x + ", " + y));
                    LOG.warn((Object)("boundingTest(polygon, " + xv + ", " + yv + ", " + w.SAMPLE_SIZE + ", " + w.SAMPLE_SIZE + ") = " + Geometry.boundingTest(this.polygon, xv, yv, w.SAMPLE_SIZE, w.SAMPLE_SIZE)));
                    LOG.warn((Object)("pc = " + Geometry.percent(xv, yv, w.SAMPLE_SIZE, w.SAMPLE_SIZE, this.polygon)));
                    int counter = 0;
                    double dx = w.SAMPLE_SIZE / 100;
                    double dy = w.SAMPLE_SIZE / 100;
                    for (int i = 0; i < 100; ++i) {
                        for (int j = 0; j < 100; ++j) {
                            double testX = dx * (double)i + (double)xv;
                            double testY = dy * (double)j + (double)yv;
                            if (!this.polygon.contains(dx * (double)i + (double)xv, dy * (double)j + (double)yv)) continue;
                            ++counter;
                            LOG.warn((Object)("Point " + testX + ", " + testY + " is inside"));
                        }
                    }
                    LOG.warn((Object)("Counted " + counter + " interior points"));
                }
            }
        }
    }

    public double getTemperature() {
        double rv = this.energy / (double)this.getCapacity();
        if (Double.isNaN(rv)) {
            LOG.warn((Object)("Building " + this.id + " getTemperature returned NaN"));
            new RuntimeException().printStackTrace();
            LOG.warn((Object)("Energy: " + this.energy));
            LOG.warn((Object)("Capacity: " + this.getCapacity()));
            LOG.warn((Object)("Volume: " + this.volume));
            LOG.warn((Object)("Thermal capacity: " + this.getThermoCapacity()));
            LOG.warn((Object)("Ground area: " + this.buildingAreaGround));
            LOG.warn((Object)("Floors: " + this.floors));
        }
        if (rv == Double.NaN || rv == Double.POSITIVE_INFINITY || rv == Double.NEGATIVE_INFINITY) {
            rv = 1.3482698511467367E308;
        }
        return rv;
    }

    public String codeToString() {
        switch (this.code) {
            case 0: {
                return "wooden";
            }
            case 1: {
                return "steelframe";
            }
        }
        return "concret";
    }

    public int getLastWater() {
        return this.lwater;
    }

    public boolean getLastWatered() {
        return this.lwTime == World.getWorld().getTime();
    }

    public boolean wasEverWatered() {
        return this.wasEverWatered;
    }

    public int getWaterQuantity() {
        return this.waterQuantity;
    }

    public void setWaterQuantity(int i) {
        if (i > this.waterQuantity) {
            this.lwTime = World.getWorld().getTime();
            this.lwater = i - this.waterQuantity;
            this.wasEverWatered = true;
        }
        this.waterQuantity = i;
    }

    public float getCapacity() {
        return this.capacity;
    }

    public void setCapacity(float f) {
        this.capacity = f;
    }

    public String toString() {
        String rv = "building " + this.getID() + "\n";
        Iterator i = this.walls.iterator();
        while (i.hasNext()) {
            rv = rv + i.next() + "\n";
        }
        return rv;
    }

    public double getRadiationEnergy() {
        double t = this.getTemperature() + 293.0;
        double radEn = t * t * t * t * this.totalWallArea * (double)Simulator.RADIATION_COEFFICENT * 5.6704E-8;
        if (this.id == 23545) {
            LOG.debug((Object)("Getting radiation energy for building " + this.id));
            LOG.debug((Object)("t = " + t));
            LOG.debug((Object)("t^4 = " + t * t * t * t));
            LOG.debug((Object)("Total wall area: " + this.totalWallArea));
            LOG.debug((Object)("Radiation coefficient: " + Simulator.RADIATION_COEFFICENT));
            LOG.debug((Object)"Stefan-Boltzmann constant: 5.6704E-8");
            LOG.debug((Object)("Radiation energy: " + radEn));
            LOG.debug((Object)("Building energy: " + this.getEnergy()));
        }
        if (radEn == Double.NaN || radEn == Double.POSITIVE_INFINITY || radEn == Double.NEGATIVE_INFINITY) {
            radEn = 1.3482698511467367E308;
        }
        if (radEn > this.getEnergy()) {
            radEn = this.getEnergy();
        }
        return radEn;
    }

    public boolean isBuilding(int x, int y) {
        return this.getX() == x && this.getY() == y;
    }

    public double getEnergy() {
        if (this.energy == Double.NaN || this.energy == Double.POSITIVE_INFINITY || this.energy == Double.NEGATIVE_INFINITY) {
            this.energy = 1.3482698511467367E308;
        }
        return this.energy;
    }

    public void setEnergy(double energy) {
        if (energy == Double.NaN || energy == Double.POSITIVE_INFINITY || energy == Double.NEGATIVE_INFINITY) {
            energy = 1.3482698511467367E308;
        }
        this.energy = energy;
    }

    public float getConsum() {
        float lf;
        if (this.fuel == 0.0f) {
            return 0.0f;
        }
        float tf = (float)(this.getTemperature() / 1000.0);
        float f = (float)((double)(tf * (lf = this.getFuel() / this.getInitialFuel())) * (Double)burnRate.nextValue());
        if (f < 0.005f) {
            f = 0.005f;
        }
        return this.getInitialFuel() * f;
    }

    public float getPrevBurned() {
        return this.prevBurned;
    }

    public void setPrevBurned(float prevBurned) {
        this.prevBurned = prevBurned;
    }

    public void setInflameable(boolean inflameable) {
        this.inflameable = inflameable;
    }

    public boolean isInflameable() {
        return this.inflameable;
    }

    static {
        POLICE_INFALMEABLE = false;
        AMBULANCE_INFALMEABLE = false;
        FIRE_INFALMEABLE = false;
        REFUGE_INFALMEABLE = false;
        woodCapacity = 4.0f;
        steelCapacity = 4.0f;
        concreteCapacity = 4.0f;
        woodIgnition = 400.0f;
        steelIgnition = 400.0f;
        concreteIgnition = 400.0f;
        woodEnergie = 1.0f;
        steelEnergie = 1.0f;
        concreteEnergie = 1.0f;
        woodBurning = 800.0f;
        steelBurning = 800.0f;
        concreteBurning = 800.0f;
    }
}

