/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.osm2gml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import maps.convert.ConvertStep;
import maps.convert.osm2gml.ConvertTools;
import maps.convert.osm2gml.TemporaryMap;
import maps.osm.OSMBuilding;
import maps.osm.OSMMap;
import maps.osm.OSMNode;
import maps.osm.OSMRoad;
import maps.osm.OSMWay;
import rescuecore2.misc.geometry.Line2D;

public class CleanOSMStep
extends ConvertStep {
    private TemporaryMap map;

    public CleanOSMStep(TemporaryMap map) {
        this.map = map;
    }

    @Override
    public String getDescription() {
        return "Cleaning OpenStreetMap data";
    }

    @Override
    protected void step() {
        OSMMap osm = this.map.getOSMMap();
        this.setProgressLimit(osm.getNodes().size() + (osm.getRoads().size() + osm.getBuildings().size()) * 2 + osm.getBuildings().size());
        this.setStatus("Looking for duplicate nodes");
        int nodes = this.fixNodes();
        this.setStatus("Fixing degenerate ways");
        int fixed = this.fixDegenerateWays(osm.getRoads());
        this.setStatus("Looking for duplicate ways");
        int ways = this.fixDuplicateWays(osm.getRoads());
        this.setStatus("Fixing building direction");
        int b = this.fixBuildingDirection(osm.getBuildings());
        this.setStatus("Removed " + nodes + " duplicate nodes and " + (ways += this.fixDuplicateWays(osm.getBuildings())) + " duplicate ways, fixed " + (fixed += this.fixDegenerateWays(osm.getBuildings())) + " degenerate ways, fixed " + b + " clockwise buildings");
    }

    private int fixNodes() {
        OSMMap osm = this.map.getOSMMap();
        int count = 0;
        double threshold = ConvertTools.nearbyThreshold(osm, this.map.getNearbyThreshold());
        HashSet<OSMNode> removed = new HashSet<OSMNode>();
        for (OSMNode next : osm.getNodes()) {
            if (removed.contains(next)) {
                this.bumpProgress();
                continue;
            }
            for (OSMNode test : osm.getNodes()) {
                if (next == test || removed.contains(test) || !this.nearby(next, test, threshold)) continue;
                osm.replaceNode(test, next);
                removed.add(test);
                ++count;
            }
            this.bumpProgress();
        }
        return count;
    }

    private int fixDegenerateWays(Collection<? extends OSMWay> ways) {
        int count = 0;
        for (OSMWay oSMWay : ways) {
            ArrayList<Long> ids = new ArrayList<Long>(oSMWay.getNodeIDs());
            Iterator it = ids.iterator();
            if (!it.hasNext()) {
                this.remove(oSMWay);
                ++count;
                continue;
            }
            long last = (Long)it.next();
            boolean fixed = false;
            while (it.hasNext()) {
                long next = (Long)it.next();
                if (next == last) {
                    it.remove();
                    fixed = true;
                }
                last = next;
            }
            if (fixed) {
                oSMWay.setNodeIDs(ids);
                ++count;
            }
            this.bumpProgress();
        }
        return count;
    }

    private int fixDuplicateWays(Collection<? extends OSMWay> ways) {
        int count = 0;
        HashSet<OSMWay> removed = new HashSet<OSMWay>();
        for (OSMWay oSMWay : ways) {
            if (removed.contains(oSMWay)) {
                this.bumpProgress();
                continue;
            }
            for (OSMWay oSMWay2 : ways) {
                if (oSMWay == oSMWay2 || removed.contains(oSMWay2)) continue;
                List<Long> testIDs = oSMWay2.getNodeIDs();
                if (this.isSubList(testIDs, oSMWay.getNodeIDs())) {
                    this.remove(oSMWay2);
                    removed.add(oSMWay2);
                    ++count;
                    continue;
                }
                Collections.reverse(testIDs);
                if (!this.isSubList(testIDs, oSMWay.getNodeIDs())) continue;
                this.remove(oSMWay2);
                removed.add(oSMWay2);
                ++count;
            }
            this.bumpProgress();
        }
        return count;
    }

    private int fixBuildingDirection(Collection<OSMBuilding> buildings) {
        OSMMap osm = this.map.getOSMMap();
        int count = 0;
        for (OSMBuilding building : buildings) {
            if (ConvertTools.isClockwise(building, osm)) {
                List<Long> ids = building.getNodeIDs();
                Collections.reverse(ids);
                building.setNodeIDs(ids);
                ++count;
            }
            this.bumpProgress();
        }
        return count;
    }

    private boolean nearby(OSMNode first, OSMNode second, double threshold) {
        double dx = first.getLongitude() - second.getLongitude();
        double dy = first.getLatitude() - second.getLatitude();
        return dx >= -threshold && dx <= threshold && dy >= -threshold && dy <= threshold;
    }

    private boolean isSubList(List<Long> first, List<Long> second) {
        return Collections.indexOfSubList(second, first) != -1;
    }

    private void remove(OSMWay way) {
        OSMMap osm = this.map.getOSMMap();
        if (way instanceof OSMRoad) {
            osm.removeRoad((OSMRoad)way);
        } else if (way instanceof OSMBuilding) {
            osm.removeBuilding((OSMBuilding)way);
        } else {
            throw new IllegalArgumentException("Don't know how to handle this type of OSMWay: " + way.getClass().getName());
        }
    }

    private Line2D makeLine(long first, long second) {
        OSMMap osm = this.map.getOSMMap();
        OSMNode n1 = osm.getNode(first);
        OSMNode n2 = osm.getNode(second);
        return new Line2D(n1.getLongitude(), n1.getLatitude(), n2.getLongitude() - n1.getLongitude(), n2.getLatitude() - n1.getLatitude());
    }
}

