/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.osm2gml;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import maps.convert.ConvertStep;
import maps.convert.osm2gml.ConvertTools;
import maps.convert.osm2gml.DirectedEdge;
import maps.convert.osm2gml.Edge;
import maps.convert.osm2gml.Node;
import maps.convert.osm2gml.TemporaryBuilding;
import maps.convert.osm2gml.TemporaryMap;
import maps.convert.osm2gml.TemporaryObject;
import maps.convert.osm2gml.TemporaryObjectInfo;
import maps.convert.osm2gml.TemporaryRoad;
import rescuecore2.misc.gui.ShapeDebugFrame;

public class MergeShapesStep
extends ConvertStep {
    private TemporaryMap map;

    public MergeShapesStep(TemporaryMap map) {
        this.map = map;
    }

    @Override
    public String getDescription() {
        return "Merging adjacent shapes";
    }

    @Override
    protected void step() {
        this.debug.setBackground(ConvertTools.getAllDebugShapes(this.map));
        Collection<TemporaryBuilding> buildings = this.map.getBuildings();
        Collection<TemporaryRoad> roads = this.map.getRoads();
        this.setProgressLimit(buildings.size() + roads.size());
        int buildingCount = 0;
        int roadCount = 0;
        for (TemporaryBuilding temporaryBuilding : buildings) {
            if (this.tryToMerge(temporaryBuilding)) {
                ++buildingCount;
            }
            this.bumpProgress();
        }
        for (TemporaryRoad temporaryRoad : roads) {
            if (this.tryToMerge(temporaryRoad)) {
                ++roadCount;
            }
            this.bumpProgress();
        }
        this.setStatus("Merged " + buildingCount + " building shapes and " + roadCount + " road shapes");
    }

    private boolean tryToMerge(TemporaryBuilding b) {
        if (!this.map.getBuildings().contains(b)) {
            return false;
        }
        Collection<TemporaryBuilding> others = this.map.getBuildings();
        for (TemporaryBuilding other : others) {
            List<DirectedEdge> boundary;
            if (b == other || other.getBuildingID() != b.getBuildingID() || (boundary = this.mergeShapes(b, other)) == null) continue;
            TemporaryBuilding newBuilding = new TemporaryBuilding(boundary, b.getBuildingID());
            this.map.addBuilding(newBuilding);
            this.map.removeBuilding(b);
            this.map.removeBuilding(other);
            this.debug.show("Merged buildings", new ShapeDebugFrame.ShapeInfo[]{new TemporaryObjectInfo(b, "First", Color.BLACK, Color.GREEN), new TemporaryObjectInfo(other, "Second", Color.BLACK, Color.WHITE), new TemporaryObjectInfo(newBuilding, "New building", Color.BLUE, null)});
            return true;
        }
        return false;
    }

    private boolean tryToMerge(TemporaryRoad r) {
        if (!this.map.getRoads().contains(r)) {
            return false;
        }
        Collection<TemporaryRoad> others = this.map.getRoads();
        for (TemporaryRoad other : others) {
            List<DirectedEdge> boundary;
            if (r == other || (boundary = this.mergeShapes(r, other)) == null || !ConvertTools.isConvex(boundary)) continue;
            TemporaryRoad newRoad = new TemporaryRoad(boundary);
            this.map.addRoad(newRoad);
            this.map.removeRoad(r);
            this.map.removeRoad(other);
            this.debug.show("Merged roads", new ShapeDebugFrame.ShapeInfo[]{new TemporaryObjectInfo(r, "First", Color.BLACK, Color.GREEN), new TemporaryObjectInfo(other, "Second", Color.BLACK, Color.WHITE), new TemporaryObjectInfo(newRoad, "New road", Color.BLUE, null)});
            return true;
        }
        return false;
    }

    private List<DirectedEdge> mergeShapes(TemporaryObject first, TemporaryObject second) {
        HashMap<Edge, DirectedEdge> edges1 = new HashMap<Edge, DirectedEdge>();
        HashMap<Edge, DirectedEdge> edges2 = new HashMap<Edge, DirectedEdge>();
        for (DirectedEdge e : first.getEdges()) {
            edges1.put(e.getEdge(), e);
        }
        for (DirectedEdge e : second.getEdges()) {
            edges2.put(e.getEdge(), e);
        }
        if (Collections.disjoint(edges1.keySet(), edges2.keySet())) {
            return null;
        }
        HashSet<DirectedEdge> boundary = new HashSet<DirectedEdge>();
        for (Map.Entry next : edges1.entrySet()) {
            if (edges2.containsKey(next.getKey())) continue;
            boundary.add((DirectedEdge)next.getValue());
        }
        for (Map.Entry next : edges2.entrySet()) {
            if (edges1.containsKey(next.getKey())) continue;
            boundary.add((DirectedEdge)next.getValue());
        }
        DirectedEdge start = (DirectedEdge)boundary.iterator().next();
        ArrayList<DirectedEdge> result = new ArrayList<DirectedEdge>();
        result.add(start);
        while (!boundary.isEmpty()) {
            start = this.findNextEdge(start, boundary);
            boundary.remove(start);
            result.add(start);
        }
        return result;
    }

    private DirectedEdge findNextEdge(DirectedEdge from, Set<DirectedEdge> candidates) {
        Node n = from.getEndNode();
        for (DirectedEdge next : candidates) {
            if (!next.getStartNode().equals(n)) continue;
            return next;
        }
        throw new IllegalArgumentException("No candidate edge starting from " + n);
    }
}

