/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.osm2gml.buildings.row;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import maps.convert.osm2gml.buildings.row.RowFiller;
import maps.gml.GMLDirectedEdge;
import maps.gml.GMLMap;
import maps.gml.GMLShape;

public final class RectangularDuplexRowFiller
implements RowFiller {
    private static final double WIDE_LOT_WIDTH_M = 25.0;
    private static final double WIDE_BUILDING_WIDTH_M = 21.0;
    private static final double WIDE_BUILDING_DEPTH_M = 7.0;
    private static final double WIDE_MIN_OFFSET_M = 2.0;
    private static final double WIDE_MAX_OFFSET_M = 10.0;
    private static final double LONG_LOT_WIDTH_M = 18.0;
    private static final double LONG_BUILDING_WIDTH_M = 15.0;
    private static final double LONG_BUILDING_DEPTH_M = 15.0;
    private static final double LONG_MIN_OFFSET_M = 1.0;
    private static final double LONG_MAX_OFFSET_M = 4.0;
    private static final int MIN_RUN_LENGTH = 1;
    private static final int MAX_RUN_LENGTH = 5;
    private final double lotWidth;
    private final double buildingWidth;
    private final double buildingDepth;
    private final double minOffset;
    private final double maxOffset;
    private final Random random;

    private RectangularDuplexRowFiller(double sizeOf1m, Random random, double lotWidth, double buildingWidth, double buildingDepth, double minOffset, double maxOffset) {
        this.lotWidth = lotWidth * sizeOf1m;
        this.buildingWidth = buildingWidth * sizeOf1m;
        this.buildingDepth = buildingDepth * sizeOf1m;
        this.minOffset = minOffset * sizeOf1m;
        this.maxOffset = maxOffset * sizeOf1m;
        this.random = random;
    }

    public static RectangularDuplexRowFiller makeWideFiller(double sizeOf1m, Random random) {
        return new RectangularDuplexRowFiller(sizeOf1m, random, 25.0, 21.0, 7.0, 2.0, 10.0);
    }

    public static RectangularDuplexRowFiller makeLongFiller(double sizeOf1m, Random random) {
        return new RectangularDuplexRowFiller(sizeOf1m, random, 18.0, 15.0, 15.0, 1.0, 4.0);
    }

    @Override
    public Set<GMLShape> fillRow(GMLDirectedEdge edge, GMLMap map) {
        HashSet<GMLShape> result = new HashSet<GMLShape>();
        return result;
    }
}

