/*
 * Decompiled with CFR 0.152.
 */
package maps.gml;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import maps.gml.GMLCoordinates;
import maps.gml.GMLDirectedEdge;
import maps.gml.GMLEdge;
import maps.gml.GMLNode;
import maps.gml.GMLObject;
import maps.gml.GMLTools;
import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Point2D;

public abstract class GMLShape
extends GMLObject {
    private List<GMLDirectedEdge> edges = new ArrayList<GMLDirectedEdge>();
    private Map<GMLDirectedEdge, Integer> neighbours = new HashMap<GMLDirectedEdge, Integer>();
    private List<GMLCoordinates> points;
    private Rectangle2D bounds = null;
    private Point2D centroid = null;

    protected GMLShape(int id) {
        super(id);
    }

    protected GMLShape(int id, List<GMLDirectedEdge> edges) {
        this(id);
        this.edges.addAll(edges);
        this.points = this.getUnderlyingCoordinates();
    }

    protected GMLShape(int id, List<GMLDirectedEdge> edges, List<Integer> neighbours) {
        this(id, edges);
        Iterator<GMLDirectedEdge> it = edges.iterator();
        Iterator<Integer> ix = neighbours.iterator();
        while (it.hasNext() && ix.hasNext()) {
            this.setNeighbour(it.next(), ix.next());
        }
        this.points = this.getUnderlyingCoordinates();
    }

    public List<GMLDirectedEdge> getEdges() {
        return new ArrayList<GMLDirectedEdge>(this.edges);
    }

    public void setEdges(List<GMLDirectedEdge> newEdges) {
        this.edges.clear();
        this.neighbours.clear();
        this.edges.addAll(newEdges);
        this.bounds = null;
        this.centroid = null;
        this.points = this.getUnderlyingCoordinates();
    }

    public void reorderEdges(List<GMLDirectedEdge> newEdges) {
        this.edges.clear();
        this.edges.addAll(newEdges);
        this.points = this.getUnderlyingCoordinates();
        this.centroid = null;
        this.neighbours.keySet().retainAll(newEdges);
    }

    public void replaceEdge(GMLDirectedEdge oldEdge, GMLDirectedEdge ... newEdges) {
        ListIterator<GMLDirectedEdge> it = this.edges.listIterator();
        while (it.hasNext()) {
            if (it.next() != oldEdge) continue;
            it.remove();
            for (GMLDirectedEdge e : newEdges) {
                it.add(e);
            }
        }
        this.bounds = null;
        this.centroid = null;
        this.points = this.getUnderlyingCoordinates();
    }

    public void removeEdge(GMLEdge edge) {
        Iterator<GMLDirectedEdge> it = this.edges.iterator();
        while (it.hasNext()) {
            GMLDirectedEdge dEdge = it.next();
            if (!dEdge.getEdge().equals(edge)) continue;
            it.remove();
            this.neighbours.remove(dEdge);
        }
        this.bounds = null;
        this.centroid = null;
        this.points = this.getUnderlyingCoordinates();
    }

    public Integer getNeighbour(GMLDirectedEdge edge) {
        return this.neighbours.get(edge);
    }

    public void setNeighbour(GMLDirectedEdge edge, Integer neighbour) {
        if (neighbour == null) {
            this.neighbours.remove(edge);
        } else {
            this.neighbours.put(edge, neighbour);
        }
    }

    public boolean hasNeighbour(GMLDirectedEdge edge) {
        return this.neighbours.containsKey(edge);
    }

    public Integer getNeighbour(GMLEdge edge) {
        return this.getNeighbour(this.findDirectedEdge(edge));
    }

    public void setNeighbour(GMLEdge edge, Integer neighbour) {
        this.setNeighbour(this.findDirectedEdge(edge), neighbour);
    }

    public boolean hasNeighbour(GMLEdge edge) {
        return this.neighbours.containsKey(this.findDirectedEdge(edge));
    }

    public List<GMLCoordinates> getUnderlyingCoordinates() {
        ArrayList<GMLCoordinates> result = new ArrayList<GMLCoordinates>();
        for (GMLDirectedEdge next : this.edges) {
            result.add(next.getStartCoordinates());
        }
        return result;
    }

    public List<GMLNode> getUnderlyingNodes() {
        ArrayList<GMLNode> result = new ArrayList<GMLNode>();
        for (GMLDirectedEdge next : this.edges) {
            result.add(next.getStartNode());
        }
        return result;
    }

    public List<GMLCoordinates> getCoordinates() {
        return Collections.unmodifiableList(this.points);
    }

    public void setCoordinates(List<GMLCoordinates> newPoints) {
        this.points.clear();
        this.points.addAll(newPoints);
        this.bounds = null;
        this.centroid = null;
    }

    public double getCentreX() {
        return this.getCentroid().getX();
    }

    public double getCentreY() {
        return this.getCentroid().getY();
    }

    public Rectangle2D getBounds() {
        if (this.bounds == null) {
            this.bounds = GMLTools.getBounds(this.getCoordinates());
        }
        return this.bounds;
    }

    public Point2D getCentroid() {
        if (this.centroid == null) {
            this.centroid = GeometryTools2D.computeCentroid(GMLTools.coordinatesAsPoints(this.getCoordinates()));
        }
        return this.centroid;
    }

    private GMLDirectedEdge findDirectedEdge(GMLEdge e) {
        for (GMLDirectedEdge next : this.edges) {
            if (!next.getEdge().equals(e)) continue;
            return next;
        }
        throw new IllegalArgumentException(this + ": Edge " + e + " not found");
    }
}

