/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import maps.gml.GMLCoordinates;
import maps.gml.GMLEdge;
import maps.gml.GMLNode;
import maps.gml.GMLTools;
import maps.gml.editor.AbstractTool;
import maps.gml.editor.GMLEditor;
import maps.gml.view.EdgeDecorator;
import maps.gml.view.LineEdgeDecorator;
import maps.gml.view.NodeDecorator;
import maps.gml.view.SquareNodeDecorator;
import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;

public class SplitEdgeTool
extends AbstractTool {
    private static final Color EDGE_COLOUR = Color.BLUE;
    private static final Color NODE_COLOUR = Color.BLACK;
    private static final int NODE_SIZE = 6;
    private Listener listener = new Listener();
    private NodeDecorator nodeHighlight = new SquareNodeDecorator(NODE_COLOUR, 6);
    private EdgeDecorator edgeHighlight = new LineEdgeDecorator(EDGE_COLOUR);
    private GMLNode node = null;
    private GMLEdge edge = null;

    public SplitEdgeTool(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Split edge";
    }

    @Override
    public void activate() {
        this.editor.getViewer().addMouseListener(this.listener);
        this.editor.getViewer().addMouseMotionListener(this.listener);
        this.node = null;
        this.edge = null;
    }

    @Override
    public void deactivate() {
        this.editor.getViewer().removeMouseListener(this.listener);
        this.editor.getViewer().removeMouseMotionListener(this.listener);
        this.editor.getViewer().clearAllNodeDecorators();
        this.editor.getViewer().clearAllEdgeDecorators();
        this.editor.getViewer().repaint();
        if (this.node != null) {
            this.editor.getMap().removeNode(this.node);
        }
    }

    private void update(GMLCoordinates c) {
        GMLEdge newEdge;
        if (this.node == null) {
            this.node = this.editor.getMap().createNode(c);
            this.editor.getViewer().setNodeDecorator(this.nodeHighlight, this.node);
        }
        if ((newEdge = this.editor.getMap().findNearestEdge(c.getX(), c.getY())) != this.edge) {
            if (this.edge != null) {
                this.editor.getViewer().clearEdgeDecorator(this.edge);
            }
            this.edge = newEdge;
            this.editor.getViewer().setEdgeDecorator(this.edgeHighlight, this.edge);
        }
        Line2D line = GMLTools.toLine(this.edge);
        Point2D point = new Point2D(c.getX(), c.getY());
        Point2D closest = GeometryTools2D.getClosestPointOnSegment((Line2D)line, (Point2D)point);
        c.setX(closest.getX());
        c.setY(closest.getY());
        this.node.setCoordinates(c);
        this.editor.getViewer().repaint();
    }

    private void split() {
        if (this.node == null || this.edge == null) {
            return;
        }
        this.editor.getMap().splitEdge(this.edge, this.node);
        this.editor.getMap().removeEdge(this.edge);
        this.editor.setChanged();
        this.editor.getViewer().clearAllNodeDecorators();
        this.editor.getViewer().clearAllEdgeDecorators();
        this.editor.getViewer().repaint();
        this.node = null;
        this.edge = null;
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p = this.fixEventPoint(e.getPoint());
            GMLCoordinates c = SplitEdgeTool.this.editor.snap(SplitEdgeTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y));
            SplitEdgeTool.this.update(c);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                SplitEdgeTool.this.split();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private Point fixEventPoint(Point p) {
            Insets insets = SplitEdgeTool.this.editor.getViewer().getInsets();
            return new Point(p.x - insets.left, p.y - insets.top);
        }
    }
}

