/*
 * Decompiled with CFR 0.152.
 */
package maps.validate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.operation.linemerge.LineSequencer;
import com.vividsolutions.jts.util.AssertionFailedException;
import maps.gml.GMLDirectedEdge;
import maps.gml.GMLNode;
import maps.gml.GMLShape;
import maps.validate.ValidationException;
import rescuecore2.misc.geometry.Point2D;

public final class JTSTools {
    private static GeometryFactory geomFactory = new GeometryFactory();

    private JTSTools() {
    }

    public static LineString edgeToLine(GMLDirectedEdge edge) {
        Coordinate[] coord = new Coordinate[]{JTSTools.nodeToCoordinate(edge.getStartNode()), JTSTools.nodeToCoordinate(edge.getEndNode())};
        return geomFactory.createLineString(coord);
    }

    public static Geometry shapeToPolygon(GMLShape shape) throws ValidationException {
        LineSequencer seq = new LineSequencer();
        for (GMLDirectedEdge e : shape.getEdges()) {
            Coordinate[] coord = new Coordinate[]{JTSTools.nodeToCoordinate(e.getStartNode()), JTSTools.nodeToCoordinate(e.getEndNode())};
            if (coord[0].equals((Object)coord[1])) {
                throw new ValidationException(e.getEdge().getID(), "Zero length edge.");
            }
            seq.add((Geometry)geomFactory.createLineString(coord));
        }
        try {
            if (!seq.isSequenceable()) {
                throw new ValidationException(shape.getID(), "Outline is not a single line.");
            }
        }
        catch (AssertionFailedException e) {
            throw new ValidationException(shape.getID(), "Could not get outline: " + e.getMessage());
        }
        Geometry line = seq.getSequencedLineStrings();
        CoordinateList coord = new CoordinateList(line.getCoordinates());
        coord.closeRing();
        if (coord.size() < 4) {
            throw new ValidationException(shape.getID(), "Degenerate Shape");
        }
        LinearRing ring = geomFactory.createLinearRing(coord.toCoordinateArray());
        return geomFactory.createPolygon(ring, null);
    }

    public static Coordinate nodeToCoordinate(GMLNode node) {
        return new Coordinate(node.getX(), node.getY());
    }

    public static Coordinate pointToCoordinate(Point2D point) {
        return new Coordinate(point.getX(), point.getY());
    }

    public static GeometryFactory getFactory() {
        return geomFactory;
    }
}

