/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import java.util.Collection;
import kernel.CommandFilter;
import kernel.KernelState;
import rescuecore2.config.Config;
import rescuecore2.log.Logger;
import rescuecore2.messages.Command;

public class FrozenAgentsCommandFilter
implements CommandFilter {
    private int freezeTime;

    @Override
    public void initialise(Config config) {
        this.freezeTime = config.getIntValue("kernel.agents.ignoreuntil", 0);
    }

    @Override
    public void filter(Collection<Command> commands, KernelState state) {
        int time = state.getTime();
        if (time < this.freezeTime) {
            Logger.info((String)("Ignoring early commands: " + time + " < " + this.freezeTime));
            commands.clear();
        }
    }
}

