/*
 * Decompiled with CFR 0.152.
 */
package kernel.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import kernel.ComponentManager;
import kernel.Kernel;
import kernel.ui.KernelControlPanel;
import kernel.ui.KernelStatus;
import rescuecore2.GUIComponent;
import rescuecore2.config.Config;
import rescuecore2.registry.Registry;

public class KernelGUI
extends JPanel {
    private static final int STATUS_SIZE = 300;
    private Kernel kernel;
    private KernelStatus status;
    private KernelControlPanel control;
    private JTabbedPane tabs;
    private Config config;

    public KernelGUI(Kernel kernel, ComponentManager componentManager, Config config, Registry registry, boolean controls) {
        super(new BorderLayout());
        this.kernel = kernel;
        this.config = config;
        this.status = new KernelStatus(kernel);
        this.status.setPreferredSize(new Dimension(300, 300));
        this.add((Component)this.status, "East");
        this.tabs = new JTabbedPane();
        this.add((Component)this.tabs, "Center");
        if (controls) {
            this.control = new KernelControlPanel(kernel, config, componentManager, registry);
            this.add((Component)this.control, "West");
            this.control.activate();
        }
        this.addGUIComponent(componentManager);
    }

    public void addGUIComponent(final GUIComponent c) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (c.getGUIComponent() != null) {
                    KernelGUI.this.tabs.addTab(c.getGUIComponentName(), c.getGUIComponent());
                }
            }
        });
    }
}

