/*
 * Decompiled with CFR 0.152.
 */
package traffic3.manager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import rescuecore2.misc.collections.LazyMap;
import rescuecore2.standard.entities.Area;
import rescuecore2.standard.entities.Blockade;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import traffic3.objects.TrafficAgent;
import traffic3.objects.TrafficArea;
import traffic3.objects.TrafficBlockade;

public class TrafficManager {
    private Map<Area, TrafficArea> areas = new HashMap<Area, TrafficArea>();
    private Map<Blockade, TrafficBlockade> blocks = new HashMap<Blockade, TrafficBlockade>();
    private Map<Human, TrafficAgent> agents = new HashMap<Human, TrafficAgent>();
    private Map<TrafficArea, Collection<TrafficArea>> areaNeighbours = new LazyMap<TrafficArea, Collection<TrafficArea>>(){

        public Collection<TrafficArea> createValue() {
            return new HashSet<TrafficArea>();
        }
    };

    public TrafficArea findArea(double x, double y) {
        for (TrafficArea next : this.getAreas()) {
            if (!next.contains(x, y)) continue;
            return next;
        }
        return null;
    }

    public Collection<TrafficArea> getNeighbours(TrafficArea area) {
        return this.areaNeighbours.get(area);
    }

    public Collection<TrafficAgent> getNearbyAgents(TrafficAgent agent) {
        HashSet<TrafficAgent> result = new HashSet<TrafficAgent>();
        result.addAll(agent.getArea().getAgents());
        for (TrafficArea next : this.getNeighbours(agent.getArea())) {
            result.addAll(next.getAgents());
        }
        result.remove(agent);
        return result;
    }

    public void clear() {
        this.areas.clear();
        this.blocks.clear();
        this.agents.clear();
        this.areaNeighbours.clear();
    }

    public void register(TrafficArea area) {
        this.areas.put(area.getArea(), area);
    }

    public void register(TrafficAgent agent) {
        this.agents.put(agent.getHuman(), agent);
    }

    public void register(TrafficBlockade block) {
        this.blocks.put(block.getBlockade(), block);
    }

    public void remove(TrafficBlockade block) {
        this.blocks.remove(block.getBlockade());
    }

    public void remove(Blockade block) {
        this.blocks.remove(block);
    }

    public Collection<TrafficAgent> getAgents() {
        return Collections.unmodifiableCollection(this.agents.values());
    }

    public Collection<TrafficArea> getAreas() {
        return Collections.unmodifiableCollection(this.areas.values());
    }

    public Collection<TrafficBlockade> getBlockades() {
        return Collections.unmodifiableCollection(this.blocks.values());
    }

    public void cacheInformation(StandardWorldModel world) {
        this.areaNeighbours.clear();
        for (StandardEntity next : world) {
            if (!(next instanceof Area)) continue;
            this.computeNeighbours((Area)next, world);
        }
    }

    public TrafficArea getTrafficArea(Area a) {
        return this.areas.get(a);
    }

    public TrafficBlockade getTrafficBlockade(Blockade b) {
        return this.blocks.get(b);
    }

    public TrafficAgent getTrafficAgent(Human h) {
        return this.agents.get(h);
    }

    private void computeNeighbours(Area a, StandardWorldModel world) {
        Collection<TrafficArea> neighbours = this.areaNeighbours.get(this.getTrafficArea(a));
        neighbours.clear();
        for (EntityID id : a.getNeighbours()) {
            Entity e = world.getEntity(id);
            if (!(e instanceof Area)) continue;
            neighbours.add(this.getTrafficArea((Area)e));
        }
    }
}

