/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import misc.HumanAttributes;
import misc.MiscParameters;
import misc.MiscSimulatorGUI;
import rescuecore2.GUIComponent;
import rescuecore2.log.Logger;
import rescuecore2.messages.Command;
import rescuecore2.messages.control.KSCommands;
import rescuecore2.standard.components.StandardSimulator;
import rescuecore2.standard.entities.AmbulanceTeam;
import rescuecore2.standard.entities.Building;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.Refuge;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardPropertyURN;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.standard.messages.AKRescue;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.EntityListener;
import rescuecore2.worldmodel.Property;

public class MiscSimulator
extends StandardSimulator
implements GUIComponent {
    private Map<EntityID, HumanAttributes> humans;
    private Set<EntityID> newlyBrokenBuildings;
    private MiscParameters parameters;
    private MiscSimulatorGUI gui;

    public JComponent getGUIComponent() {
        if (this.gui == null) {
            this.gui = new MiscSimulatorGUI();
        }
        return this.gui;
    }

    public String getGUIComponentName() {
        return "Misc simulator";
    }

    protected void postConnect() {
        super.postConnect();
        this.parameters = new MiscParameters(this.config);
        this.humans = new HashMap<EntityID, HumanAttributes>();
        this.newlyBrokenBuildings = new HashSet<EntityID>();
        Logger.info((String)("MiscSimulator connected. World has " + ((StandardWorldModel)this.model).getAllEntities().size() + " entities."));
        BuildingChangeListener buildingListener = new BuildingChangeListener();
        for (StandardEntity et : ((StandardWorldModel)this.model).getAllEntities()) {
            if (et instanceof Building) {
                et.addEntityListener((EntityListener)buildingListener);
                continue;
            }
            if (!(et instanceof Human)) continue;
            Human human = (Human)et;
            HumanAttributes ha = new HumanAttributes(human, this.config);
            this.humans.put(ha.getID(), ha);
        }
    }

    protected void processCommands(KSCommands c, ChangeSet changes) {
        long start = System.currentTimeMillis();
        int time = c.getTime();
        Logger.info((String)("Timestep " + time));
        for (Command com : c.getCommands()) {
            if (this.checkValidity(com)) {
                if (!(com instanceof AKRescue)) continue;
                Human human = (Human)((StandardWorldModel)this.model).getEntity(((AKRescue)com).getTarget());
                this.handleRescue(human, changes);
                continue;
            }
            Logger.debug((String)("Ignoring " + com));
        }
        this.processBrokenBuildings(changes);
        this.processBurningBuildings(changes);
        this.updateDamage(changes);
        this.newlyBrokenBuildings.clear();
        this.writeDebugOutput(c.getTime());
        if (this.gui != null) {
            this.gui.refresh(this.humans.values());
        }
        long end = System.currentTimeMillis();
        Logger.info((String)("Timestep " + time + " took " + (end - start) + " ms"));
    }

    private void processBrokenBuildings(ChangeSet changes) {
        for (HumanAttributes hA : this.humans.values()) {
            int damage;
            int buriedness;
            Human human = hA.getHuman();
            EntityID positionID = human.getPosition();
            if (!this.newlyBrokenBuildings.contains(positionID)) continue;
            Logger.trace((String)"Checking if human should be buried in broken building");
            Building b = (Building)human.getPosition(this.model);
            if (this.parameters.shouldBuryAgent(b) && (buriedness = this.parameters.getBuriedness(b)) != 0) {
                int oldBuriedness = human.isBuriednessDefined() ? human.getBuriedness() : 0;
                human.setBuriedness(Math.max(oldBuriedness, buriedness));
                changes.addChange((Entity)human, (Property)human.getBuriednessProperty());
                int damage2 = this.parameters.getBuryDamage(b, human);
                if (damage2 != 0) {
                    hA.addBuriednessDamage(damage2);
                }
            }
            if ((damage = this.parameters.getCollapseDamage(b, human)) == 0) continue;
            hA.addCollapseDamage(damage);
        }
    }

    private void processBurningBuildings(ChangeSet changes) {
        for (HumanAttributes hA : this.humans.values()) {
            int damage;
            Human human = hA.getHuman();
            EntityID positionID = human.getPosition();
            StandardEntity position = human.getPosition(this.model);
            if (!(position instanceof Building) || !((Building)position).isOnFire() || (damage = this.parameters.getFireDamage((Building)position, human)) == 0) continue;
            hA.addFireDamage(damage);
        }
    }

    private void writeDebugOutput(int time) {
        StringBuilder builder = new StringBuilder();
        Formatter format = new Formatter(builder);
        format.format("Agents damaged or buried at timestep %1d%n", time);
        format.format("    ID    |   HP   | Damage |   Bury   | Collapse |   Fire   | Buriedness%n", new Object[0]);
        for (HumanAttributes ha : this.humans.values()) {
            boolean isBuried;
            Human h = ha.getHuman();
            int hp = h.isHPDefined() ? h.getHP() : 0;
            int damage = ha.getTotalDamage();
            int buriedness = h.isBuriednessDefined() ? h.getBuriedness() : 0;
            boolean isAlive = hp > 0;
            boolean hasDamage = damage > 0;
            boolean bl = isBuried = buriedness > 0;
            if (!hasDamage && !isBuried || !isAlive) continue;
            format.format("%1$9d | %2$6d | %3$6d | %4$8.3f | %5$8.3f | %6$8.3f | %7$6d%n", ha.getID().getValue(), hp, damage, ha.getBuriednessDamage(), ha.getCollapseDamage(), ha.getFireDamage(), buriedness);
        }
        Logger.debug((String)builder.toString());
    }

    private void updateDamage(ChangeSet changes) {
        for (HumanAttributes ha : this.humans.values()) {
            boolean hasDamage;
            this.updateDamage(ha);
            Human h = ha.getHuman();
            int hp = h.isHPDefined() ? h.getHP() : 0;
            int damage = ha.getTotalDamage();
            h.setDamage(damage);
            changes.addChange((Entity)ha.getHuman(), (Property)ha.getHuman().getDamageProperty());
            boolean isAlive = hp > 0;
            boolean bl = hasDamage = damage > 0;
            if (isAlive && hasDamage) {
                int newHP = Math.max(0, hp - damage);
                h.setHP(newHP);
                changes.addChange((Entity)ha.getHuman(), (Property)ha.getHuman().getHPProperty());
            }
            if (!(h.getPosition(this.model) instanceof Refuge)) continue;
            ha.clearDamage();
            h.setDamage(0);
            changes.addChange((Entity)ha.getHuman(), (Property)ha.getHuman().getDamageProperty());
        }
    }

    private void updateDamage(HumanAttributes ha) {
        Human h = ha.getHuman();
        if (h.getHP() <= 0) {
            return;
        }
        ha.progressDamage();
    }

    private boolean checkValidity(Command command) {
        Entity e = ((StandardWorldModel)this.model).getEntity(command.getAgentID());
        if (e == null) {
            Logger.warn((String)("Received a " + command.getURN() + " command from an unknown agent: " + command.getAgentID()));
            return false;
        }
        if (command instanceof AKRescue) {
            return this.checkRescue((AKRescue)command, e);
        }
        return false;
    }

    private boolean checkRescue(AKRescue rescue, Entity agent) {
        EntityID targetID = rescue.getTarget();
        Entity target = ((StandardWorldModel)this.model).getEntity(targetID);
        if (!(agent instanceof AmbulanceTeam)) {
            Logger.warn((String)("Rejecting rescue command from agent " + agent.getID() + " who is of type " + agent.getURN()));
            return false;
        }
        if (target == null) {
            Logger.warn((String)("Rejecting rescue command from agent " + agent.getID() + " for a non-existant target " + targetID));
            return false;
        }
        if (!(target instanceof Human)) {
            Logger.warn((String)("Rejecting rescue command from agent " + agent.getID() + " for a non-human target: " + targetID + " is of type " + target.getURN()));
            return false;
        }
        Human h = (Human)target;
        AmbulanceTeam at = (AmbulanceTeam)agent;
        if (at.isHPDefined() && at.getHP() <= 0) {
            Logger.warn((String)("Rejecting rescue command from agent " + agent.getID() + ": agent is dead"));
            return false;
        }
        if (at.isBuriednessDefined() && at.getBuriedness() > 0) {
            Logger.warn((String)("Rejecting rescue command from agent " + agent.getID() + ": agent is buried"));
            return false;
        }
        if (!h.isBuriednessDefined() || h.getBuriedness() == 0) {
            Logger.warn((String)("Rejecting rescue command from agent " + agent.getID() + " for a non-buried target " + targetID));
            return false;
        }
        if (!(h.isPositionDefined() && at.isPositionDefined() && h.getPosition().equals((Object)at.getPosition()))) {
            Logger.warn((String)("Rejecting rescue command from agent " + agent.getID() + " for a non-adjacent target " + targetID));
            return false;
        }
        if (h.getID().equals((Object)at.getID())) {
            Logger.warn((String)("Rejecting rescue command from agent " + agent.getID() + ": tried to rescue self"));
            return false;
        }
        return true;
    }

    private void handleRescue(Human target, ChangeSet changes) {
        target.setBuriedness(Math.max(0, target.getBuriedness() - 1));
        changes.addChange((Entity)target, (Property)target.getBuriednessProperty());
    }

    private class BuildingChangeListener
    implements EntityListener {
        private BuildingChangeListener() {
        }

        public void propertyChanged(Entity e, Property p, Object oldValue, Object newValue) {
            double next;
            if (!(e instanceof Building)) {
                return;
            }
            if (!p.getURN().equals(StandardPropertyURN.BROKENNESS.toString())) {
                return;
            }
            double old = oldValue == null ? 0.0 : (double)((Integer)oldValue).intValue();
            double d = next = newValue == null ? 0.0 : (double)((Integer)newValue).intValue();
            if (next > old) {
                MiscSimulator.this.newlyBrokenBuildings.add(e.getID());
            }
        }
    }
}

