/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.log;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import rescuecore2.log.LogException;
import rescuecore2.log.LogRecord;
import rescuecore2.log.RecordType;
import rescuecore2.messages.Command;
import rescuecore2.messages.Message;
import rescuecore2.misc.EncodingTools;

public class CommandsRecord
implements LogRecord {
    private int time;
    private Collection<Command> commands;

    public CommandsRecord(int time, Collection<Command> commands) {
        this.time = time;
        this.commands = commands;
    }

    public CommandsRecord(InputStream in) throws IOException, LogException {
        this.read(in);
    }

    @Override
    public RecordType getRecordType() {
        return RecordType.COMMANDS;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        EncodingTools.writeInt32(this.time, out);
        EncodingTools.writeInt32(this.commands.size(), out);
        for (Command next : this.commands) {
            EncodingTools.writeMessage((Message)next, out);
        }
    }

    @Override
    public void read(InputStream in) throws IOException, LogException {
        this.time = EncodingTools.readInt32(in);
        this.commands = new ArrayList<Command>();
        int count = EncodingTools.readInt32(in);
        for (int i = 0; i < count; ++i) {
            Message m = EncodingTools.readMessage(in);
            if (m == null) {
                throw new LogException("Could not read message from stream");
            }
            if (!(m instanceof Command)) {
                throw new LogException("Illegal message type in commands record: " + m);
            }
            this.commands.add((Command)m);
        }
    }

    public int getTime() {
        return this.time;
    }

    public Collection<Command> getCommands() {
        return this.commands;
    }
}

