/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.log;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import rescuecore2.config.Config;
import rescuecore2.log.AbstractLogReader;
import rescuecore2.log.CommandsRecord;
import rescuecore2.log.ConfigRecord;
import rescuecore2.log.InitialConditionsRecord;
import rescuecore2.log.LogException;
import rescuecore2.log.PerceptionRecord;
import rescuecore2.log.RecordType;
import rescuecore2.log.UpdatesRecord;
import rescuecore2.misc.EncodingTools;
import rescuecore2.registry.Registry;
import rescuecore2.worldmodel.DefaultWorldModel;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.WorldModel;

public class StreamLogReader
extends AbstractLogReader {
    private int maxTime;
    private Map<Integer, CommandsRecord> commands = new HashMap<Integer, CommandsRecord>();
    private Map<Integer, UpdatesRecord> updates = new HashMap<Integer, UpdatesRecord>();
    private Map<Integer, WorldModel<? extends Entity>> worldModels = new HashMap<Integer, WorldModel<? extends Entity>>();
    private Map<Integer, Map<EntityID, PerceptionRecord>> perception = new HashMap<Integer, Map<EntityID, PerceptionRecord>>();
    private Config config;

    public StreamLogReader(InputStream in, Registry registry) throws LogException {
        super(registry);
        try {
            this.readLog(in);
        }
        catch (IOException e) {
            throw new LogException(e);
        }
    }

    @Override
    public Config getConfig() throws LogException {
        if (this.config == null) {
            throw new LogException("No config record found");
        }
        return this.config;
    }

    @Override
    public int getMaxTimestep() throws LogException {
        return this.maxTime;
    }

    @Override
    public WorldModel<? extends Entity> getWorldModel(int time) throws LogException {
        this.checkTime(time);
        WorldModel<? extends Entity> result = this.worldModels.get(time);
        if (result == null) {
            result = DefaultWorldModel.create();
        }
        return result;
    }

    @Override
    public Set<EntityID> getEntitiesWithUpdates(int time) throws LogException {
        this.checkTime(time);
        Map<EntityID, PerceptionRecord> agentData = this.perception.get(time);
        HashSet<EntityID> result = new HashSet<EntityID>();
        if (agentData != null) {
            result.addAll(agentData.keySet());
        }
        return result;
    }

    @Override
    public PerceptionRecord getPerception(int time, EntityID entity) throws LogException {
        this.checkTime(time);
        Map<EntityID, PerceptionRecord> agentData = this.perception.get(time);
        if (agentData == null) {
            return null;
        }
        PerceptionRecord result = agentData.get(entity);
        return result;
    }

    @Override
    public CommandsRecord getCommands(int time) throws LogException {
        this.checkTime(time);
        return this.commands.get(time);
    }

    @Override
    public UpdatesRecord getUpdates(int time) throws LogException {
        this.checkTime(time);
        return this.updates.get(time);
    }

    private void checkTime(int time) {
        if (time < 0 || time > this.maxTime) {
            throw new IllegalArgumentException("Time is out of range: " + time + " should be between 0 and " + this.maxTime);
        }
    }

    private void readLog(InputStream in) throws IOException, LogException {
        RecordType type;
        Registry.setCurrentRegistry(this.registry);
        boolean startFound = false;
        do {
            int id = EncodingTools.readInt32(in);
            type = RecordType.fromID(id);
            if (!startFound) {
                if (type != RecordType.START_OF_LOG) {
                    throw new LogException("Log does not start with correct magic number");
                }
                startFound = true;
            }
            this.readRecord(type, in);
        } while (type != RecordType.END_OF_LOG);
    }

    private void readRecord(RecordType type, InputStream in) throws IOException, LogException {
        int size = EncodingTools.readInt32(in);
        byte[] data = EncodingTools.readBytes(size, in);
        ByteArrayInputStream d = new ByteArrayInputStream(data);
        switch (type) {
            case INITIAL_CONDITIONS: {
                this.readInitialConditions(d);
                break;
            }
            case PERCEPTION: {
                this.readPerception(d);
                break;
            }
            case COMMANDS: {
                this.readCommands(d);
                break;
            }
            case UPDATES: {
                this.readUpdates(d);
                break;
            }
            case CONFIG: {
                this.readConfig(d);
                break;
            }
            case END_OF_LOG: {
                return;
            }
            default: {
                throw new LogException("Unexpected record type: " + (Object)((Object)type));
            }
        }
    }

    private void readInitialConditions(InputStream in) throws IOException, LogException {
        InitialConditionsRecord record = new InitialConditionsRecord(in);
        this.worldModels.put(0, record.getWorldModel());
    }

    private void readPerception(InputStream in) throws IOException, LogException {
        PerceptionRecord record = new PerceptionRecord(in);
        int time = record.getTime();
        Map<EntityID, PerceptionRecord> agentData = this.perception.get(time);
        if (agentData == null) {
            agentData = new HashMap<EntityID, PerceptionRecord>();
            this.perception.put(time, agentData);
        }
        agentData.put(record.getEntityID(), record);
        this.maxTime = Math.max(time, this.maxTime);
    }

    private void readCommands(InputStream in) throws IOException, LogException {
        CommandsRecord record = new CommandsRecord(in);
        this.commands.put(record.getTime(), record);
        this.maxTime = Math.max(record.getTime(), this.maxTime);
    }

    private void readUpdates(InputStream in) throws IOException, LogException {
        UpdatesRecord record = new UpdatesRecord(in);
        int time = record.getTime();
        this.updates.put(time, record);
        DefaultWorldModel<Entity> newWorld = new DefaultWorldModel<Entity>(Entity.class);
        WorldModel<? extends Entity> oldWorld = this.getWorldModel(time - 1);
        if (oldWorld != null) {
            HashSet<Entity> copy = new HashSet<Entity>();
            for (Entity entity : oldWorld) {
                copy.add(entity.copy());
            }
            newWorld.merge(copy);
        }
        newWorld.merge(record.getChangeSet());
        this.worldModels.put(time, newWorld);
        this.maxTime = Math.max(time, this.maxTime);
    }

    private void readConfig(InputStream in) throws IOException, LogException {
        ConfigRecord record = new ConfigRecord(in);
        this.config = record.getConfig();
    }
}

