/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.messages.components;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import rescuecore2.config.Config;
import rescuecore2.messages.AbstractMessageComponent;
import rescuecore2.misc.EncodingTools;

public class ConfigComponent
extends AbstractMessageComponent {
    private Config config;

    public ConfigComponent(String name) {
        super(name);
        this.config = new Config();
    }

    public ConfigComponent(String name, Config data) {
        super(name);
        this.config = data;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        Set<String> keys = this.config.getAllKeys();
        EncodingTools.writeInt32(keys.size(), out);
        for (String key : keys) {
            EncodingTools.writeString(key, out);
            EncodingTools.writeString(this.config.getValue(key), out);
        }
    }

    @Override
    public void read(InputStream in) throws IOException {
        int count = EncodingTools.readInt32(in);
        this.config = new Config();
        for (int i = 0; i < count; ++i) {
            String key = EncodingTools.readString(in);
            String value = EncodingTools.readString(in);
            this.config.setValue(key, value);
        }
    }

    public String toString() {
        return this.getName() + " (" + this.config.getAllKeys().size() + " entries)";
    }
}

