/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.view;

import java.util.Collection;
import java.util.List;
import javax.swing.JMenuItem;
import rescuecore2.config.Config;
import rescuecore2.view.LayerViewComponent;
import rescuecore2.view.ViewLayer;

public abstract class AbstractViewLayer
implements ViewLayer {
    protected LayerViewComponent component;
    private boolean visible = true;

    protected AbstractViewLayer() {
    }

    @Override
    public void setLayerViewComponent(LayerViewComponent c) {
        this.component = c;
    }

    @Override
    public List<JMenuItem> getPopupMenuItems() {
        return null;
    }

    @Override
    public void initialise(Config config) {
    }

    @Override
    public void setVisible(boolean b) {
        this.visible = b;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    protected void processView(Object ... objects) {
        if (objects == null) {
            return;
        }
        for (Object next : objects) {
            this.process(next);
        }
    }

    protected abstract void viewObject(Object var1);

    private void process(Object o) {
        if (o == null) {
            return;
        }
        if (o instanceof Collection) {
            for (Object next : (Collection)o) {
                this.process(next);
            }
        } else if (o.getClass().isArray()) {
            for (Object next : (Object[])o) {
                this.process(next);
            }
        } else {
            this.viewObject(o);
        }
    }
}

