/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.worldmodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import rescuecore2.log.Logger;
import rescuecore2.misc.EncodingTools;
import rescuecore2.misc.collections.LazyMap;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.Property;

public class ChangeSet {
    private Map<EntityID, Map<String, Property>> changes = new LazyMap<EntityID, Map<String, Property>>(){

        @Override
        public Map<String, Property> createValue() {
            return new HashMap<String, Property>();
        }
    };
    private Set<EntityID> deleted;
    private Map<EntityID, String> entityURNs = new HashMap<EntityID, String>();

    public ChangeSet() {
        this.deleted = new HashSet<EntityID>();
    }

    public ChangeSet(ChangeSet other) {
        this();
        this.merge(other);
    }

    public void addChange(Entity e, Property p) {
        this.addChange(e.getID(), e.getURN(), p);
    }

    public void addChange(EntityID e, String urn, Property p) {
        if (this.deleted.contains(e)) {
            return;
        }
        Property prop = p.copy();
        this.changes.get(e).put(prop.getURN(), prop);
        this.entityURNs.put(e, urn);
    }

    public void entityDeleted(EntityID e) {
        this.deleted.add(e);
        this.changes.remove(e);
    }

    public Set<Property> getChangedProperties(EntityID e) {
        return new HashSet<Property>(this.changes.get(e).values());
    }

    public Property getChangedProperty(EntityID e, String urn) {
        Map<String, Property> props = this.changes.get(e);
        if (props != null) {
            return props.get(urn);
        }
        return null;
    }

    public Set<EntityID> getChangedEntities() {
        return new HashSet<EntityID>(this.changes.keySet());
    }

    public Set<EntityID> getDeletedEntities() {
        return new HashSet<EntityID>(this.deleted);
    }

    public String getEntityURN(EntityID id) {
        return this.entityURNs.get(id);
    }

    public void merge(ChangeSet other) {
        for (Map.Entry<EntityID, Map<String, Property>> next : other.changes.entrySet()) {
            EntityID e = next.getKey();
            String urn = other.getEntityURN(e);
            for (Property p : next.getValue().values()) {
                this.addChange(e, urn, p);
            }
        }
        this.deleted.addAll(other.deleted);
    }

    public void addAll(Collection<? extends Entity> c) {
        for (Entity entity : c) {
            for (Property property : entity.getProperties()) {
                if (!property.isDefined()) continue;
                this.addChange(entity, property);
            }
        }
    }

    public void write(OutputStream out) throws IOException {
        EncodingTools.writeInt32(this.changes.size(), out);
        for (Map.Entry<EntityID, Map<String, Property>> entry : this.changes.entrySet()) {
            EntityID id = entry.getKey();
            Collection<Property> props = entry.getValue().values();
            EncodingTools.writeInt32(id.getValue(), out);
            EncodingTools.writeString(this.getEntityURN(id), out);
            EncodingTools.writeInt32(props.size(), out);
            for (Property prop : props) {
                EncodingTools.writeProperty(prop, out);
            }
        }
        EncodingTools.writeInt32(this.deleted.size(), out);
        for (EntityID entityID : this.deleted) {
            EncodingTools.writeInt32(entityID.getValue(), out);
        }
    }

    public void read(InputStream in) throws IOException {
        this.changes.clear();
        this.deleted.clear();
        int entityCount = EncodingTools.readInt32(in);
        for (int i = 0; i < entityCount; ++i) {
            EntityID id = new EntityID(EncodingTools.readInt32(in));
            String urn = EncodingTools.readString(in);
            int propCount = EncodingTools.readInt32(in);
            for (int j = 0; j < propCount; ++j) {
                Property p = EncodingTools.readProperty(in);
                if (p == null) continue;
                this.addChange(id, urn, p);
            }
        }
        int deletedCount = EncodingTools.readInt32(in);
        for (int i = 0; i < deletedCount; ++i) {
            EntityID id = new EntityID(EncodingTools.readInt32(in));
            this.deleted.add(id);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("ChangeSet:");
        for (Map.Entry<EntityID, Map<String, Property>> next : this.changes.entrySet()) {
            result.append(" Entity ");
            result.append(next.getKey());
            result.append(" (");
            result.append(this.getEntityURN(next.getKey()));
            result.append(") [");
            Iterator<Property> it = next.getValue().values().iterator();
            while (it.hasNext()) {
                result.append(it.next());
                if (!it.hasNext()) continue;
                result.append(", ");
            }
            result.append("]");
        }
        result.append(" {Deleted ");
        Iterator<EntityID> it = this.deleted.iterator();
        while (it.hasNext()) {
            result.append(it.next());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        result.append("}");
        return result.toString();
    }

    public void debug() {
        Logger.debug("ChangeSet");
        for (Map.Entry<EntityID, Map<String, Property>> next : this.changes.entrySet()) {
            Logger.debug("  Entity " + next.getKey() + "(" + this.getEntityURN(next.getKey()) + ")");
            Iterator<Property> it = next.getValue().values().iterator();
            while (it.hasNext()) {
                Logger.debug("    " + it.next());
            }
        }
        Iterator<EntityID> it = this.deleted.iterator();
        while (it.hasNext()) {
            Logger.debug("  Deleted: " + it.next());
        }
    }
}

