/*
 * Decompiled with CFR 0.152.
 */
package misc;

import misc.DamageType;
import rescuecore2.config.Config;
import rescuecore2.standard.entities.Human;
import rescuecore2.worldmodel.EntityID;

public class HumanAttributes {
    private Human human;
    private EntityID id;
    private DamageType damageFire;
    private DamageType damageCollapse;
    private DamageType damageBury;

    public HumanAttributes(Human h, Config config) {
        this.human = h;
        this.id = h.getID();
        this.damageFire = new DamageType("fire", config);
        this.damageCollapse = new DamageType("collapse", config);
        this.damageBury = new DamageType("bury", config);
    }

    public EntityID getID() {
        return this.id;
    }

    public Human getHuman() {
        return this.human;
    }

    public void addCollapseDamage(double d) {
        this.damageCollapse.addDamage(d);
    }

    public double getCollapseDamage() {
        return this.damageCollapse.getDamage();
    }

    public void setCollapseDamage(double d) {
        this.damageCollapse.setDamage(d);
    }

    public void addBuriednessDamage(double d) {
        this.damageBury.addDamage(d);
    }

    public double getBuriednessDamage() {
        return this.damageBury.getDamage();
    }

    public void setBuriednessDamage(double d) {
        this.damageBury.setDamage(d);
    }

    public void addFireDamage(double d) {
        this.damageFire.addDamage(d);
    }

    public double getFireDamage() {
        return this.damageFire.getDamage();
    }

    public void setFireDamage(double d) {
        this.damageFire.setDamage(d);
    }

    public int getTotalDamage() {
        return (int)Math.round(this.damageCollapse.getDamage() + this.damageFire.getDamage() + this.damageBury.getDamage());
    }

    public void progressDamage() {
        this.damageCollapse.progress();
        this.damageFire.progress();
        this.damageBury.progress();
    }

    public void clearDamage() {
        this.damageCollapse.setDamage(0.0);
        this.damageBury.setDamage(0.0);
        this.damageFire.setDamage(0.0);
    }
}

