/*
 * Decompiled with CFR 0.152.
 */
package firesimulator;

import firesimulator.simulator.ExtinguishRequest;
import firesimulator.simulator.Simulator;
import firesimulator.util.Configuration;
import firesimulator.world.AmbulanceCenter;
import firesimulator.world.AmbulanceTeam;
import firesimulator.world.Building;
import firesimulator.world.Civilian;
import firesimulator.world.FireBrigade;
import firesimulator.world.FireStation;
import firesimulator.world.MovingObject;
import firesimulator.world.PoliceForce;
import firesimulator.world.PoliceOffice;
import firesimulator.world.Refuge;
import firesimulator.world.RescueObject;
import firesimulator.world.World;
import firesimulator.world.WorldInfo;
import java.util.Collection;
import rescuecore2.config.NoSuchConfigOptionException;
import rescuecore2.log.Logger;
import rescuecore2.messages.control.KSCommands;
import rescuecore2.messages.control.KSUpdate;
import rescuecore2.standard.components.StandardSimulator;
import rescuecore2.standard.entities.AmbulanceCentre;
import rescuecore2.standard.entities.Blockade;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.Road;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.standard.messages.AKExtinguish;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.Property;

public class FireSimulatorWrapper
extends StandardSimulator {
    private static final String MAX_WATER_KEY = "fire.tank.maximum";
    private Simulator sim;
    private World world;

    protected void postConnect() {
        super.postConnect();
        Configuration c = new Configuration();
        c.initialize();
        for (String next : c.getPropertyNames()) {
            try {
                String value = this.config.getValue(next);
                Configuration.setProperty((String)next, (String)value, (boolean)true);
                Logger.debug((String)("Setting '" + next + "' to '" + value + "'"));
            }
            catch (NoSuchConfigOptionException e) {
                Logger.debug((String)("Ignoring property " + next));
            }
        }
        this.world = new World();
        this.sim = new Simulator(this.world);
        for (String next : (StandardWorldModel)this.model) {
            RescueObject r = this.mapEntity((Entity)next);
            if (r == null) continue;
            this.world.putObject(r);
        }
        this.sim.initialize();
    }

    protected void handleUpdate(KSUpdate u) {
        super.handleUpdate(u);
        for (EntityID id : u.getChangeSet().getChangedEntities()) {
            Entity e = ((StandardWorldModel)this.model).getEntity(id);
            RescueObject r = this.world.getObject(id.getValue());
            if (r == null) {
                r = this.mapEntity(e);
                if (r == null) continue;
                this.world.putObject(r);
                continue;
            }
            if (r instanceof Building && e instanceof rescuecore2.standard.entities.Building) {
                int fieryness;
                Building b = (Building)r;
                this.mapBuildingProperties((rescuecore2.standard.entities.Building)e, b);
                if (b.getIgnition() != 1 || !b.isInflameable() || (fieryness = b.getFieryness()) != 0 && fieryness != 4) continue;
                Logger.debug((String)("Igniting " + b));
                b.ignite();
                continue;
            }
            if (r instanceof MovingObject && e instanceof Human) {
                this.mapHumanProperties((Human)e, (MovingObject)r);
                continue;
            }
            Logger.error((String)("Don't know how to map " + r + " from " + e));
        }
    }

    protected void processCommands(KSCommands c, ChangeSet changes) {
        FireBrigade fb;
        long start = System.currentTimeMillis();
        for (Object next : c.getCommands()) {
            if (!(next instanceof AKExtinguish)) continue;
            AKExtinguish ex = (AKExtinguish)next;
            EntityID agentID = ex.getAgentID();
            EntityID targetID = ex.getTarget();
            int water = ex.getWater();
            FireBrigade source = (FireBrigade)this.world.getObject(agentID.getValue());
            Building target = (Building)this.world.getObject(targetID.getValue());
            ExtinguishRequest req = new ExtinguishRequest(source, target, water);
            this.world.addExtinguishRequest((Object)req);
        }
        this.sim.step(c.getTime());
        for (Object next : this.world.getBuildings()) {
            Building b = (Building)next;
            rescuecore2.standard.entities.Building oldB = (rescuecore2.standard.entities.Building)((StandardWorldModel)this.model).getEntity(new EntityID(b.getID()));
            if (!oldB.isFierynessDefined() || oldB.getFieryness() != b.getFieryness()) {
                oldB.setFieryness(b.getFieryness());
                changes.addChange((Entity)oldB, (Property)oldB.getFierynessProperty());
            }
            if (oldB.isTemperatureDefined() && oldB.getTemperature() == (int)b.getTemperature()) continue;
            oldB.setTemperature((int)b.getTemperature());
            changes.addChange((Entity)oldB, (Property)oldB.getTemperatureProperty());
        }
        for (Object next : this.world.getFirebrigades()) {
            fb = (FireBrigade)next;
            rescuecore2.standard.entities.FireBrigade oldFB = (rescuecore2.standard.entities.FireBrigade)((StandardWorldModel)this.model).getEntity(new EntityID(fb.getID()));
            if (oldFB.isWaterDefined() && oldFB.getWater() == fb.getWaterQuantity()) continue;
            oldFB.setWater(fb.getWaterQuantity());
            changes.addChange((Entity)oldFB, (Property)oldFB.getWaterProperty());
        }
        if (c.getTime() == 1) {
            for (Object next : ((StandardWorldModel)this.model).getEntitiesOfType(StandardEntityURN.FIRE_BRIGADE)) {
                fb = (rescuecore2.standard.entities.FireBrigade)next;
                fb.setWater(this.config.getIntValue(MAX_WATER_KEY));
                changes.addChange((Entity)fb, (Property)fb.getWaterProperty());
            }
        }
        long end = System.currentTimeMillis();
        Logger.info((String)("Time " + c.getTime() + " took " + (end - start) + "ms"));
    }

    private RescueObject mapEntity(Entity e) {
        int id = e.getID().getValue();
        if (e instanceof rescuecore2.standard.entities.World) {
            return new WorldInfo(id);
        }
        if (e instanceof rescuecore2.standard.entities.Refuge) {
            Refuge r = new Refuge(id);
            this.mapBuildingProperties((rescuecore2.standard.entities.Building)e, (Building)r);
            return r;
        }
        if (e instanceof rescuecore2.standard.entities.FireStation) {
            FireStation fs = new FireStation(id);
            this.mapBuildingProperties((rescuecore2.standard.entities.Building)e, (Building)fs);
            return fs;
        }
        if (e instanceof rescuecore2.standard.entities.PoliceOffice) {
            PoliceOffice po = new PoliceOffice(id);
            this.mapBuildingProperties((rescuecore2.standard.entities.Building)e, (Building)po);
            return po;
        }
        if (e instanceof AmbulanceCentre) {
            AmbulanceCenter ac = new AmbulanceCenter(id);
            this.mapBuildingProperties((rescuecore2.standard.entities.Building)e, (Building)ac);
            return ac;
        }
        if (e instanceof rescuecore2.standard.entities.Building) {
            Building b = new Building(id);
            this.mapBuildingProperties((rescuecore2.standard.entities.Building)e, b);
            return b;
        }
        if (e instanceof rescuecore2.standard.entities.Civilian) {
            Civilian c = new Civilian(id);
            this.mapHumanProperties((Human)((rescuecore2.standard.entities.Civilian)e), (MovingObject)c);
            return c;
        }
        if (e instanceof rescuecore2.standard.entities.FireBrigade) {
            FireBrigade fb = new FireBrigade(id);
            this.mapHumanProperties((Human)((rescuecore2.standard.entities.FireBrigade)e), (MovingObject)fb);
            return fb;
        }
        if (e instanceof rescuecore2.standard.entities.PoliceForce) {
            PoliceForce pf = new PoliceForce(id);
            this.mapHumanProperties((Human)((rescuecore2.standard.entities.PoliceForce)e), (MovingObject)pf);
            return pf;
        }
        if (e instanceof rescuecore2.standard.entities.AmbulanceTeam) {
            AmbulanceTeam at = new AmbulanceTeam(id);
            this.mapHumanProperties((Human)((rescuecore2.standard.entities.AmbulanceTeam)e), (MovingObject)at);
            return at;
        }
        if (e instanceof Road) {
            return null;
        }
        if (e instanceof Blockade) {
            return null;
        }
        Logger.error((String)("Don't know how to map this: " + e));
        return null;
    }

    private void mapBuildingProperties(rescuecore2.standard.entities.Building oldB, Building newB) {
        if (oldB.isFloorsDefined()) {
            newB.setFloors(oldB.getFloors());
        }
        if (oldB.isBuildingAttributesDefined()) {
            newB.setAttributes(oldB.getBuildingAttributes());
        }
        if (oldB.isIgnitionDefined()) {
            newB.setIgnition(oldB.getIgnition() ? 1 : 0);
        }
        if (oldB.isFierynessDefined()) {
            newB.setFieryness(oldB.getFieryness());
        }
        if (oldB.isBrokennessDefined()) {
            newB.setBrokenness(oldB.getBrokenness());
        }
        if (oldB.isBuildingCodeDefined()) {
            newB.setCode(oldB.getBuildingCode());
        }
        if (oldB.isGroundAreaDefined()) {
            newB.setBuildingAreaGround((float)oldB.getGroundArea());
        }
        if (oldB.isTotalAreaDefined()) {
            newB.setBuildingAreaTotal((float)oldB.getTotalArea());
        }
        if (oldB.isEdgesDefined()) {
            newB.setApexes(oldB.getApexList());
        }
        if (oldB.isXDefined()) {
            newB.setX(oldB.getX());
        }
        if (oldB.isYDefined()) {
            newB.setY(oldB.getY());
        }
    }

    private void mapHumanProperties(Human oldH, MovingObject newH) {
        if (oldH.isStaminaDefined()) {
            newH.setStamina(oldH.getStamina());
        }
        if (oldH.isHPDefined()) {
            newH.setHp(oldH.getHP());
        }
        if (oldH.isDamageDefined()) {
            newH.setDamage(oldH.getDamage());
        }
        if (oldH.isBuriednessDefined()) {
            newH.setBuriedness(oldH.getBuriedness());
        }
        if (oldH.isPositionDefined()) {
            newH.setPositionId(oldH.getPosition().getValue());
        }
        if (oldH.isXDefined()) {
            newH.setX(oldH.getX());
        }
        if (oldH.isYDefined()) {
            newH.setY(oldH.getY());
        }
        if (oldH instanceof rescuecore2.standard.entities.FireBrigade && newH instanceof FireBrigade) {
            rescuecore2.standard.entities.FireBrigade oldFB = (rescuecore2.standard.entities.FireBrigade)oldH;
            FireBrigade newFB = (FireBrigade)newH;
            if (oldFB.isWaterDefined()) {
                newFB.setInitialWaterQuantity(oldFB.getWater());
            }
        }
    }

    private int[] collectionToIDArray(Collection<EntityID> list) {
        int[] ids = new int[list.size()];
        int i = 0;
        for (EntityID next : list) {
            ids[i++] = next.getValue();
        }
        return ids;
    }
}

