/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.kernel.comms;

import rescuecore2.config.Config;
import rescuecore2.log.Logger;
import rescuecore2.standard.kernel.comms.AbstractChannel;
import rescuecore2.standard.kernel.comms.InvalidMessageException;
import rescuecore2.standard.messages.AKSpeak;

public class RadioChannel
extends AbstractChannel {
    private static final String BANDWIDTH_SUFFIX = ".bandwidth";
    private int bandwidth;
    private int usedBandwidth;

    public RadioChannel(Config config, int channelID) {
        super(channelID);
        this.bandwidth = config.getIntValue("comms.channels." + channelID + BANDWIDTH_SUFFIX);
    }

    @Override
    public void timestep() {
        super.timestep();
        this.usedBandwidth = 0;
    }

    @Override
    public void pushImpl(AKSpeak speak) throws InvalidMessageException {
        byte[] data = speak.getContent();
        if (this.usedBandwidth + data.length > this.bandwidth) {
            throw new InvalidMessageException("Discarding message on channel " + this.channelID + ": already used " + this.usedBandwidth + " of " + this.bandwidth + " bytes, new message is " + data.length + " bytes.");
        }
        Logger.debug((String)(this + " accepted message from " + speak.getAgentID()));
        this.addMessageForSubscribers(speak);
        this.usedBandwidth += data.length;
    }

    public String toString() {
        return "Radio channel " + this.channelID + " (bandwidth = " + this.bandwidth + ")";
    }
}

